/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_RPLISTINFO_H
#define _SC_RPLISTINFO_H

// sc
#include "svn/svn.h"
#include "svn/DirEntryTypes.h"
#include "util/String.h"


class RpListInfo
{
public:
  RpListInfo( const sc::String& url, svn::Revnumber rev, const svn::Date& date,
    const svn::DirEntries& entries );

  const sc::String& getUrl() const;
  const svn::Revnumber& getRevnumber() const;
  const svn::Date&  getDate() const;
  const svn::DirEntries& getDirEntries() const;

  unsigned long getAge() const;

  bool isEmpty() const;
  void operator=( const RpListInfo& );
  bool operator==( const RpListInfo& );

private:
  sc::String      _url;
  svn::Revnumber  _rev;
  svn::Date       _date;
  svn::DirEntries _entries;
};


#endif // _SC_RPLISTINFO_H
