/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_PROPLISTCMD_H
#define _SC_PROPLISTCMD_H

// sc
#include "ScCmd.h"
class CmdResultCallback;
class PropListParam;


/**
 * Command for listing the properties of a path or url.
 */
class PropListCmd : public ScCmd
{
public:
  /**
   * Construct a PropListCmd.
   *
   * \param param the parameters for the command. The command takes ownership
   * of the parameter object and deletes it if it itself destroyed.
   *
   * \param cb the callback that gets called when the command has finished.
   * 
   */
  PropListCmd( PropListParam* param, CmdResultCallback* cb );
  ~PropListCmd();

  void run();

private:
  // in
  PropListParam*     _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_PROPLISTCMD_H
