/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _LINE_PAINTER_H
#define _LINE_PAINTER_H

// sc
class PaintLine;

// qt
#include <QtGui/QColor>
class QPainter;

/**
 * \brief helper class for drawing text lines.
 */

class LinePainter
{
public:
  LinePainter();
  LinePainter( const QColor& nc, const QColor& wsc, const QColor& nchl, const QColor& wschl );
  virtual ~LinePainter();

  void drawLine( QPainter& pp, int x, int y, const PaintLine* line );

  void setNormalColor( const QColor& );
  void setNormalColorHL( const QColor& );
  void setWhitespaceColor( const QColor& );
  void setWhitespaceColorHL( const QColor& );

private:
  const QColor& getColor( unsigned int );

  enum ColorOffset
  {
    normal,
    normalHL,
    white,
    whiteHL,
    maxoff
  };

  QColor _colors[maxoff];
};


#endif // _LINE_PAINTER_H
