/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "LogEntry.h"


namespace svn
{

LogEntry::Path::Path( const char* path, const svn_log_changed_path_t* svnpath )
{
  _path         = sc::String(path);
  _action       = svnpath->action;
  _copyFromPath = sc::String(svnpath->copyfrom_path);
  _copyFromRev  = svnpath->copyfrom_rev;
}

bool LogEntry::Path::isCopied() const
{
  return _copyFromRev != -1 && !_copyFromPath.isEmpty();
}

bool LogEntry::Path::isAdded() const
{
  return _action == 'A';
}

bool LogEntry::Path::isModified() const
{
  return _action == 'M';
}

bool LogEntry::Path::isDeleted() const
{
  return _action == 'D';
}

bool LogEntry::Path::isReplaced() const
{
  return _action == 'R';
}

const sc::String& LogEntry::Path::getCopyFromPath() const
{
  return _copyFromPath;
}

Revnumber LogEntry::Path::getCopyFromRev() const
{
  return _copyFromRev;
}

const sc::String& LogEntry::Path::getPath() const
{
  return _path;
}

char LogEntry::Path::getAction() const
{
  return _action;
}

//
///////////////////////////////////////////////////////////////////////////////
//

LogEntry::LogEntry( Revnumber rev, Date date, const sc::String& author, const sc::String& msg )
: _rev(rev), _date(date), _author(author), _msg(msg)
{
}

Revnumber LogEntry::getRevnumber() const
{
  return _rev;
}

Date LogEntry::getDate() const
{
  return _date;
}

const sc::String& LogEntry::getAuthor() const
{
  return _author;
}

const sc::String& LogEntry::getMessage() const
{
  return _msg;
}

void LogEntry::addPath( const Path& path )
{
  _paths.push_back(path);
}

const LogEntry::ChangedPaths& LogEntry::getPaths() const
{
  return _paths;
}

void LogEntry::setMessage( const sc::String& msg ) const
{
  // uh... :(
  LogEntry* le = const_cast<LogEntry*>(this);
  le->_msg = msg;
}


} // namespace
