

/*
    THIS FILE IS GENERATED AUTOMATICALLY. DO NOT EDIT: CHANGES WILL BE OVERWRITTEN.
    File generated by traciObject.xslt.
*/

/*   
    Copyright (C) 2013 ApPeAL Group, Politecnico di Torino

    This file is part of TraCI4J.

    TraCI4J is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    TraCI4J is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with TraCI4J.  If not, see <http://www.gnu.org/licenses/>.
*/


package it.polito.appeal.traci;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/**

	Representation of an induction loop in the SUMO environment.
	@see <a href="http://sumo.sourceforge.net/doc/current/docs/userdoc/Simulation/Output/Induction_Loops_Detectors_(E1).html">SUMO documentation</a>
	@author Enrico Gueli &lt;enrico.gueli@polito.it&gt;
	
*/
public class InductionLoop 
extends TraciObject<InductionLoop.Variable>
implements StepAdvanceListener
{

	/**
	 * Enumerates all the read queries. Each value can be used as an argument
	 * for {@link TraciObject#getReadQuery(Enum)}.
	 * 
	 * @author Enrico Gueli &lt;enrico.gueli@polito.it&gt;
	 */	
	public static enum Variable {
		
		/** 
		 * Query "ReadLane"
		 * @see {@link #queryReadLane}
		 */
		LANE,
		
		/** 
		 * Query "ReadPositionInLane"
		 * @see {@link #queryReadPositionInLane}
		 */
		POSITION,
		
		/** 
		 * Query "ReadLastStepVehicleNumber"
		 * @see {@link #queryReadLastStepVehicleNumber}
		 */
		VEHICLE_NUMBER,
		
		/** 
		 * Query "ReadLastStepMeanSpeed"
		 * @see {@link #queryReadLastStepMeanSpeed}
		 */
		MEAN_SPEED,
		
		/** 
		 * Query "ReadLastStepVehicles"
		 * @see {@link #queryReadLastStepVehicles}
		 */
		LAST_STEP_VEHICLES,
		
	}
	
	InductionLoop (
		DataInputStream dis,
		DataOutputStream dos, 
		String id
		
			, Repository<Lane> repoLane
			, Repository<Vehicle> repoVehicle
	) {
		super(id, Variable.class);

		/*
		 * initialization of read queries
		 */
		
		addReadQuery(Variable.LANE, 
				new ReadObjectVarQuery.LaneQ (dis, dos, 
				it.polito.appeal.traci.protocol.Constants.CMD_GET_INDUCTIONLOOP_VARIABLE, 
				id, 
				it.polito.appeal.traci.protocol.Constants.VAR_LANE_ID
				, repoLane
				
				));
		
		addReadQuery(Variable.POSITION, 
				new ReadObjectVarQuery.PositionQ (dis, dos, 
				it.polito.appeal.traci.protocol.Constants.CMD_GET_INDUCTIONLOOP_VARIABLE, 
				id, 
				it.polito.appeal.traci.protocol.Constants.VAR_POSITION
				
				));
		
		addReadQuery(Variable.VEHICLE_NUMBER, 
				new ReadObjectVarQuery.IntegerQ (dis, dos, 
				it.polito.appeal.traci.protocol.Constants.CMD_GET_INDUCTIONLOOP_VARIABLE, 
				id, 
				it.polito.appeal.traci.protocol.Constants.LAST_STEP_VEHICLE_NUMBER
				
				));
		
		addReadQuery(Variable.MEAN_SPEED, 
				new ReadObjectVarQuery.DoubleQ (dis, dos, 
				it.polito.appeal.traci.protocol.Constants.CMD_GET_INDUCTIONLOOP_VARIABLE, 
				id, 
				it.polito.appeal.traci.protocol.Constants.LAST_STEP_MEAN_SPEED
				
				));
		
		addReadQuery(Variable.LAST_STEP_VEHICLES, 
				new VehicleSetQuery (dis, dos, 
				it.polito.appeal.traci.protocol.Constants.CMD_GET_INDUCTIONLOOP_VARIABLE, 
				id, 
				it.polito.appeal.traci.protocol.Constants.LAST_STEP_VEHICLE_ID_LIST
				, repoVehicle
				
				));
		

		/*
		 * initialization of change state queries
		 */
		
	
	}
	
	
	
	@Override
	public void nextStep(double step) {
		
		getReadQuery(Variable.VEHICLE_NUMBER).setObsolete();
		
		getReadQuery(Variable.MEAN_SPEED).setObsolete();
		
		getReadQuery(Variable.LAST_STEP_VEHICLES).setObsolete();
		
	}
	
	
	
	
	
	/**
	 * @return the instance of {@link ReadObjectVarQuery} relative to this query.
	 */
	public ReadObjectVarQuery<Lane> queryReadLane() {
		return (ReadObjectVarQuery.LaneQ) getReadQuery(Variable.LANE);
	}
	
	
	/**
	 * Executes an instance of {@link ReadObjectVarQuery} relative to this query,
	 * and returns the corresponding value.
	 */
	public Lane getLane() throws IOException {
		return ((ReadObjectVarQuery.LaneQ) getReadQuery(Variable.LANE)).get();
	}
	
	/**
	 * @return the instance of {@link ReadObjectVarQuery} relative to this query.
	 */
	public ReadObjectVarQuery<java.awt.geom.Point2D> queryReadPositionInLane() {
		return (ReadObjectVarQuery.PositionQ) getReadQuery(Variable.POSITION);
	}
	
	
	/**
	 * Executes an instance of {@link ReadObjectVarQuery} relative to this query,
	 * and returns the corresponding value.
	 */
	public java.awt.geom.Point2D getPosition() throws IOException {
		return ((ReadObjectVarQuery.PositionQ) getReadQuery(Variable.POSITION)).get();
	}
	
	/**
	 * @return the instance of {@link ReadObjectVarQuery} relative to this query.
	 */
	public ReadObjectVarQuery<Integer> queryReadLastStepVehicleNumber() {
		return (ReadObjectVarQuery.IntegerQ) getReadQuery(Variable.VEHICLE_NUMBER);
	}
	
	
	/**
	 * Executes an instance of {@link ReadObjectVarQuery} relative to this query,
	 * and returns the corresponding value.
	 */
	public Integer getVehicleNumber() throws IOException {
		return ((ReadObjectVarQuery.IntegerQ) getReadQuery(Variable.VEHICLE_NUMBER)).get();
	}
	
	/**
	 * @return the instance of {@link ReadObjectVarQuery} relative to this query.
	 */
	public ReadObjectVarQuery<Double> queryReadLastStepMeanSpeed() {
		return (ReadObjectVarQuery.DoubleQ) getReadQuery(Variable.MEAN_SPEED);
	}
	
	
	/**
	 * Executes an instance of {@link ReadObjectVarQuery} relative to this query,
	 * and returns the corresponding value.
	 */
	public Double getMeanSpeed() throws IOException {
		return ((ReadObjectVarQuery.DoubleQ) getReadQuery(Variable.MEAN_SPEED)).get();
	}
	
	/**
	 * @return the instance of {@link ReadObjectVarQuery} relative to this query.
	 */
	public ReadObjectVarQuery<java.util.Set<Vehicle>> queryReadLastStepVehicles() {
		return (VehicleSetQuery) getReadQuery(Variable.LAST_STEP_VEHICLES);
	}
	
	
	/**
	 * Executes an instance of {@link ReadObjectVarQuery} relative to this query,
	 * and returns the corresponding value.
	 */
	public java.util.Set<Vehicle> getLastStepVehicles() throws IOException {
		return ((VehicleSetQuery) getReadQuery(Variable.LAST_STEP_VEHICLES)).get();
	}
	
}

