
from swiginac import *

# --- Derivation of manufactured analytical solution:

# Some useful symbols
x = symbol("x[0]")
b = symbol("b")
K = symbol("K")

# Picking an arbitrary solution
u = sin(x) - x

# Want to compute g!

# Compute P(F)
F = symbol("F")
E = (F**2-1)/2
Q = b*E**2
psi = K*(exp(Q)-1)
P = diff(psi, F)

# Compute value of F 
#Fvalue = 1 + u.dx(0) = 1 + cos(x) - 1
Fvalue = 1 + diff(u, x)

# Substitute value of F into P
repmap = exmap()
repmap[F] = Fvalue
P = P.subs(repmap)

# Compute g using strong form of equation
g = diff(P, x)

# Print solutions
print
print "u:"
print "    value[0] =", u.printc()
print
print "g:"
print "    value[0] =", g.printc()
print

