// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#ifndef P0FE_IS_INCLUDED
#define P0FE_IS_INCLUDED

#include "FE.h"

namespace SyFi
{

	class P0 : public StandardFE
	{
		public:
			P0();
			P0(Polygon& p, unsigned int order = 0);
			virtual ~P0() {}

			virtual void compute_basis_functions();
	};

	class VectorP0 : public StandardFE
	{
		protected:
			unsigned int size;
		public:
			VectorP0();
			VectorP0(Polygon& p, unsigned int order = 0, unsigned int size = 0 );
			~VectorP0() {}

			virtual void set_size(unsigned int size_);
			virtual void compute_basis_functions();
	};

	class TensorP0 : public StandardFE
	{
		protected:
			unsigned int size;
		public:
			TensorP0();
			TensorP0(Polygon& p, unsigned int order = 0, unsigned int size = 0 );
			~TensorP0() {}

			virtual void set_size(unsigned int size_);
			virtual void compute_basis_functions();
	};

}
#endif
