.TH "MIME message tool" 1 mime "MIME tool"

.SH NAME
mime-tool \- a simple program to construct MIME messages with attached files

.SH SYNOPSIS
.B mime
[
.B -dDvV
] [
.B -S
subject
] [
.B -F
from-address
] [
.B -T
to-address
] [
.B -C
carbon-copy address
] [
.B -P
prolog-text
] [
.B -E
epiplogue-text
] [
.B -B
boundary
] [
.B -O
overall content-type
] { [
.B -78abiquxopm
] [
.B -t
content-type
] filename }

.SH DESCRIPTION
The
.B mime
program constructs MIME messages with attached files. The user can specify
the content type (application/octet-stream, text/plain or a user specified
type), content type encoding (7bit, 8bit, binary, base64 and auto-detect),
content disposition (attached or inline) and the content boundary string.
The user can also specify some mail related options: subject, from-address,
to-address, carbon-copy address, prolog-text and epilog-text.

The output of the MIME-tool program can be sent directly to the
.IR mail ", " mailx " or " sendmail
commands (or any other command that accepts RFC-822 formatted messages).

.B NOTE:
Specifying 7-bit encoding for an attachment that contains 8-bit data will
convert any data bytes whose high-bit is set to question marks.

.SH OPTIONS
.TP
.B -7
7-bit ASCII encoding
.TP
.B -8
8-bit ASCII encoding
.TP
.B -a
application/octet-stream content type
.TP
.B -b
binary encoding
.TP
.B -d
low detail debugging
.TP
.B -D
high detail debugging
.TP
.B -s
write a subpart
.TP
.B -i
disposition: inline (instead of attachment)
.TP
.B -q
quoted-printable encoding
.TP
.B -c content-type
explicit content type
.TP
.B -t
text/plain content type
.TP
.B -o
omit disposition line
.TP
.B -u
unknown encoding, auto-detect
.TP
.B -v
verbose messages
.TP
.B -V
very verbose messages
.TP
.B -x
base64 encoding
.TP
.B -p
copy existing MIME part
.TP
.B -o
omit content-disposition
.TP
.B -m
omit content-transfer-encoding
.TP
.B -n filename
override the filename in the disposition header
.TP
.B -N
don't add a filename parameter in the disposition header
.TP
.B -0
no-op

.SH EXAMPLES

Using MIME-tool to write a mail message to a file:

.RS
mime -S "test message" -F me@foo.net -T someone@somewhere.net file1 > test.msg
.RE

Using MIME-tool with the
.I mail
command:

.RS
mime -S "test message" -F me@foo.net file1 | mail someone@somewhere.net
.RE

Using MIME-tool with the
.I mailx
command:

.RS
mime -S "test message" -F me@foo.net file1 | mailx someone@somewhere.net
.RE

Using MIME-tool with the
.I sendmail
command:

.RS
mime -S "test message" -F me@foo.net file1 | sendmail someone@somewhere.net
.RE

.SH VERSION
This is version 1.5.topal3 from June 2009.

.SH KNOWN BUGS
Most of the header values are not properly quoted or folded, so long or
complex values for these headers may cause problems. Specifically, the
from-address, to-address, carbon-copy-address and content-type headers
may not be properly quoted or folded.

For some reason, certain e-mail clients (espcially from a large software
company located in Redmond, Washington) don't seem to recognize file
attachments as attachments, but instead displays them as inline attachments.
(maybe this isn't MIME-tool's fault, but I've gotten a few e-mails about it,
so I'm mentioning it here)

.SH AUTHOR
.B mime
is written by Jeffrey Dutky <dutky@bellatlantic.net>

Oscar Esteban spotted an off-by-one error in the base64 encoding function.

Sergey Lapin spotted a bug in the filename header construction.

Chris Hemphill noticed that the documentation (this manual page and the
README file) didn't include any examples of how to call the program with
common mail commands.

Some additional fixes and additions by Phil Brooke to support Topal.

.SH AVAILABILITY
The original MIME-tool package can be downloaded from my web page at
http://members.bellatlantic.net/~dutky

This modified version is distributed with Topal:

http://homepage.ntlworld.com/phil.brooke/topal/
