-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2022  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

with Globals;  use Globals;

package Sending is

   -- We want to send a message.
   procedure Send (Tmpfile     : in String;
                   Recipients  : in UBS_Array;
		   Remaining   : in UBS_Array := UBS_Array'(1..0 => ToUBS(""));
                   Non_Pine    : in Boolean   := False;
                   Mime        : in Boolean   := False;
                   Mimefile    : in String    := "";
		   Actual_Send : in Boolean   := False);

   -- Make sure the user really wants to send this.
   procedure Check_Send (Tmpfile   : in String;
                         Non_Pine  : in Boolean;
                         Mime      : in Boolean;
                         Mimefile  : in String;
                         Hdrfile   : in String;
                         Recipients : in UBS_Array;
			 Actual_Send : in Boolean := False;
			 Send_Comment : in String := "");
   
   -- Pre-processing for the sendmail-path filter.
   -- We assume that Tmpfile contains both header & body.
   function Get_Recipients (Tmpfile : String) return UBS_Array_Pointer;
   
end Sending;
