#ifndef INCLUDED_THEX_H
#define INCLUDED_THEX_H
/* vim: set ts=8 sts=4 sw=4 tw=80 noet: */
/*======================================================================
Copyright (C) 2004,2005,2009 Walter Doekes <walter+tthsum@wjd.nu>
This file is part of tthsum.

tthsum is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

tthsum is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with tthsum.  If not, see <http://www.gnu.org/licenses/>.
======================================================================*/

/**
 * Calculates the root of the merkle hash tree.
 */

#include "read.h"
#include "types.h"

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Calculate the THEX/Tiger (TTH) root of the specified file.
 * The root hash will be placed in res which must be at least 3 uint64_t's
 * long.
 */
int thex_tiger_root(struct rofile* stream, uint64_t* result,
	void (*progress_func)(uint64_t,uint64_t));


#ifdef __cplusplus
} /* extern "C" */
#endif /* __cplusplus */

#endif /* INCLUDED_THEX_H */
