/*
 *  Welcome System
 *  author: Anthony DIllon
 */

function WelcomeSystem($parent){
	var _parent = $parent;
	var _this = this;
	var _isOpen = false;
	
	this.init = function(){
		
		this.open();
		$('#welcome #welcome-screen ul a').bind('click',function(e){
			_this.startTour($(this).attr('class'));
		});
		
		$('#welcome-screen .jump-to-tour').change(function(){
			_this.startTour($(this).attr('value'));
		});
		
		$('#welcome  #welcome-screen').show();
		var hash = window.location.hash; 
		if (hash != undefined) {
			_this.startTour(hash.substring(1));
		}
		this.center();
	}
	
	this.applyTicks = function(){
		if(_parent.guidedTourSystem.getGuides()[0].complete && !$('#welcome  #welcome-screen .send-an-email').hasClass('completed')){
			$('#welcome  #welcome-screen .send-an-email').addClass('completed');
		}
		if(_parent.guidedTourSystem.getGuides()[1].complete && !$('#welcome  #welcome-screen .watch-video').hasClass('completed')){
			$('#welcome  #welcome-screen .watch-video').addClass('completed');
		}
		if(_parent.guidedTourSystem.getGuides()[2].complete && !$('#welcome  #welcome-screen .surf-the-web').hasClass('completed')){
			$('#welcome  #welcome-screen .surf-the-web').addClass('completed');
		}
		if(_parent.guidedTourSystem.getGuides()[3].complete && !$('#welcome  #welcome-screen .find-apps').hasClass('completed')){
			$('#welcome  #welcome-screen .find-apps').addClass('completed');
		}
		if(_parent.guidedTourSystem.getGuides()[4].complete && !$('#welcome  #welcome-screen .listen-music').hasClass('completed')){
			$('#welcome  #welcome-screen .listen-music').addClass('completed');
		}
		if(_parent.guidedTourSystem.getGuides()[5].complete && !$('#welcome  #welcome-screen .view-photos').hasClass('completed')){
			$('#welcome  #welcome-screen .view-photos').addClass('completed');
		}
		if(_parent.guidedTourSystem.getGuides()[6].complete && !$('#welcome  #welcome-screen .browse-files').hasClass('completed')){
			$('#welcome  #welcome-screen .browse-files').addClass('completed');
		}
		if(_parent.guidedTourSystem.getGuides()[7].complete && !$('#welcome  #welcome-screen .create-documents').hasClass('completed')){
			$('#welcome  #welcome-screen .create-documents').addClass('completed');
		}
		if(_parent.guidedTourSystem.getGuides()[8].complete && !$('#welcome  #welcome-screen .create-spreadsheets').hasClass('completed')){
			$('#welcome  #welcome-screen .create-spreadsheets').addClass('completed');
		}
		if(_parent.guidedTourSystem.getGuides()[9].complete && !$('#welcome  #welcome-screen .create-presentations').hasClass('completed')){
			$('#welcome  #welcome-screen .create-presentations').addClass('completed');
		}
		if(_parent.guidedTourSystem.getGuides()[10].complete && !$('#welcome  #welcome-screen .system-indicators').hasClass('completed')){
			$('#welcome  #welcome-screen .system-indicators').addClass('completed');
		}
		if(_parent.guidedTourSystem.getGuides()[11].complete && !$('#welcome  #welcome-screen .ubuntu-one').hasClass('completed')){
			$('#welcome  #welcome-screen .ubuntu-one').addClass('completed');
		}
		if(_parent.guidedTourSystem.getGuides()[12].complete && !$('#welcome  #welcome-screen .applications').hasClass('completed')){
			$('#welcome  #welcome-screen .applications').addClass('completed');
		}
	}
	
	this.startTour = function(tourId) {
		tourId = tourId.replace(" completed","");
		switch(tourId){
			case 'send-an-email':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(0);
			break;
			case 'watch-video':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(1);
			break;
			case 'surf-the-web':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(2);
			break;
			case 'find-apps':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(3);
			break;
			case 'listen-music':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(4);
			break;
			case 'view-photos':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(5);
			break;
			case 'browse-files':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(6);
			break;
			case 'create-documents':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(7);
			break;
			case 'create-spreadsheets':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(8);
			break;
			case 'create-presentations':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(9);
			break;
			case 'system-indicators':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(10);
			break;
			case 'ubuntu-one':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(11);
			break;
			case 'applications':
				$('#welcome').hide();
				_isOpen = false;
				_parent.guidedTourSystem.setCurrentIndex(12);
			break;
			default:
				return false;
			break;
		}
		$('#tour-guide .explore-to-welcome').bind('click',function(){
			_parent.guidedTourSystem.reset();
			_this.open();
		});
		$('#tour-guide .explore-to-welcome').bind('mouseover',function(){
			$('#tour-guide .explore-tooltip-welcome').show();
		});
		$('#tour-guide .explore-to-welcome').bind('mouseout',function(){
			$('#tour-guide .explore-tooltip-welcome').hide();
		});
	}
	
	this.open = function(){
		_isOpen = true;
		this.applyTicks();
		
		$('#welcome').show();
		this.center();
	}
	
	this.close = function(){
		_isOpen = false;
		$('#welcome').hide();
	}
	
	this.center = function(){
    	var left = ($(document).width() / 2) - ($('#welcome-screen').outerWidth() / 2);
		var top = Math.max(24,($(document).height() / 2) - ($('#welcome-screen').outerHeight() / 2));
		$('#welcome #welcome-screen').css('left',left);
		$('#welcome #welcome-screen').css('top',top); 
	}
	    
	this.resize = function(){
		this.center();
	}
	
	this.isOpen = function(){
		return _isOpen;
	}
	
}
