/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 */
#include <QDesktopWidget>
#include <QApplication>
#include <QScreen>
#include <QColor>
#include <QPalette>
#include <QStyleOption>
#include <QPainter>

#include "fullscreenmask.h"


FullScreenMask::FullScreenMask(QWidget *parent) : QWidget(parent)
{
    setWindowFlags(Qt::FramelessWindowHint |
                   Qt::X11BypassWindowManagerHint); //无边框、禁止拖动、禁止改变大小、不受窗管管理
    setAttribute(Qt::WA_TranslucentBackground);                    //透明背景
    setFixedSize(QApplication::desktop()->width(),
                 QApplication::desktop()->height());
    move(QGuiApplication::primaryScreen()->geometry().x(),
         QGuiApplication::primaryScreen()->geometry().y());
}

void FullScreenMask::paintEvent(QPaintEvent *event)
{
    //绘制背景
    QStyleOption opt;
    opt.init(this);
    QPainter p(this);
    QBrush brush(QColor(165,165,165,255*0.8));
    p.setBrush(brush);
    p.setOpacity(0.3);
    p.setPen(Qt::NoPen);
    QPainterPath path;
    QRect mainRect(0, 0, this->width(), this->height());
    path.addRoundedRect(mainRect, 0, 0);
    p.setRenderHint(QPainter::Antialiasing);
    p.drawRoundedRect(mainRect, 0, 0);
    style()->drawPrimitive(QStyle::PE_Widget, &opt, &p, this);

    QWidget::paintEvent(event);
}
