/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

#include "CIM_ServiceAccessPoint.h"
using namespace CimClassNamespace;

CIM_ServiceAccessPoint::RequestStateChange_INPUT::RequestStateChange_INPUT()
	:Serializable("RequestStateChange_INPUT", CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX),
	RequestedStateSpecified(false),
	TimeoutPeriodSpecified(false){}

void CIM_ServiceAccessPoint::RequestStateChange_INPUT::SerializeMembers(XMLElement& node) const
{
	if(RequestedStateSpecified)
	{
		node.AppendLeaf("RequestedState", RequestedState, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
	if(TimeoutPeriodSpecified)
	{
		node.AppendLeaf("TimeoutPeriod", TimeoutPeriod, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
}

CIM_ServiceAccessPoint::RequestStateChange_OUTPUT::RequestStateChange_OUTPUT()
	:DeSerializable("RequestStateChange_OUTPUT",CIM_ServiceAccessPoint::CLASS_URI),
	JobSpecified(false){}

void CIM_ServiceAccessPoint::RequestStateChange_OUTPUT::SetValue(const XMLElement& node)
{
	string name = node.GetNodeName();
	if(name == "Job")
	{
		node.SetComplexType(Job);
		JobSpecified = true;
	}
	else if(name == "ReturnValue")
	{
		node.SetValue(ReturnValue);
	}
}

CIM_ServiceAccessPoint::CIM_ServiceAccessPoint(
		const string& objName,
		const string& uri,
		const string& ns,
		const string& nsPrefix)
		:CIM_EnabledLogicalElement(objName, uri, ns, nsPrefix){}

void  CIM_ServiceAccessPoint::SerializeMembers(XMLElement& node) const
{
	if(CaptionSpecified)
	{
		node.AppendLeaf("Caption", Caption, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
	node.AppendLeaf("CreationClassName", CreationClassName, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	if(DescriptionSpecified)
	{
		node.AppendLeaf("Description", Description, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
	if(ElementNameSpecified)
	{
		node.AppendLeaf("ElementName", ElementName, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
	if(EnabledDefaultSpecified)
	{
		node.AppendLeaf("EnabledDefault", EnabledDefault, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
	if(EnabledStateSpecified)
	{
		node.AppendLeaf("EnabledState", EnabledState, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
	if(HealthStateSpecified)
	{
		node.AppendLeaf("HealthState", HealthState, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
	if(InstallDateSpecified)
	{
		node.AppendLeaf("InstallDate", InstallDate, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
	node.AppendLeaf("Name", Name, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	node.AppendLeafArray("OperationalStatus", OperationalStatus, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	if(OtherEnabledStateSpecified)
	{
		node.AppendLeaf("OtherEnabledState", OtherEnabledState, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
	if(RequestedStateSpecified)
	{
		node.AppendLeaf("RequestedState", RequestedState, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
	if(StatusSpecified)
	{
		node.AppendLeaf("Status", Status, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
	node.AppendLeafArray("StatusDescriptions", StatusDescriptions, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	node.AppendLeaf("SystemCreationClassName", SystemCreationClassName, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	node.AppendLeaf("SystemName", SystemName, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	if(TimeOfLastStateChangeSpecified)
	{
		node.AppendLeaf("TimeOfLastStateChange", TimeOfLastStateChange, CIM_ServiceAccessPoint::CLASS_URI, CIM_ServiceAccessPoint::CLASS_NS_PREFIX);
	}
}

NameValuePairs CIM_ServiceAccessPoint::GetSelectorsList() const
{
	NameValuePairs serList;
	serList["CreationClassName"] = XMLTypeConverter::TypeToString(CreationClassName);
	serList["Name"] = XMLTypeConverter::TypeToString(Name);
	serList["SystemCreationClassName"] = XMLTypeConverter::TypeToString(SystemCreationClassName);
	serList["SystemName"] = XMLTypeConverter::TypeToString(SystemName);
	return serList;
}

void CIM_ServiceAccessPoint::SetValue(const XMLElement& node)
{
	string name = node.GetNodeName();
	if(name == "TimeOfLastStateChange")
	{
		node.SetValue(TimeOfLastStateChange);
		TimeOfLastStateChangeSpecified = true;
	}
	else if(name == "EnabledDefault")
	{
		node.SetValue(EnabledDefault);
		EnabledDefaultSpecified = true;
	}
	else if(name == "RequestedState")
	{
		node.SetValue(RequestedState);
		RequestedStateSpecified = true;
	}
	else if(name == "OtherEnabledState")
	{
		node.SetValue(OtherEnabledState);
		OtherEnabledStateSpecified = true;
	}
	else if(name == "EnabledState")
	{
		node.SetValue(EnabledState);
		EnabledStateSpecified = true;
	}
	else if(name == "HealthState")
	{
		node.SetValue(HealthState);
		HealthStateSpecified = true;
	}
	else if(name == "Status")
	{
		node.SetValue(Status);
		StatusSpecified = true;
	}
	else if(name == "StatusDescriptions")
	{
		node.AddValue(StatusDescriptions);
	}
	else if(name == "OperationalStatus")
	{
		node.AddValue(OperationalStatus);
	}
	else if(name == "InstallDate")
	{
		node.SetValue(InstallDate);
		InstallDateSpecified = true;
	}
	else if(name == "Caption")
	{
		node.SetValue(Caption);
		CaptionSpecified = true;
	}
	else if(name == "Description")
	{
		node.SetValue(Description);
		DescriptionSpecified = true;
	}
	else if(name == "ElementName")
	{
		node.SetValue(ElementName);
		ElementNameSpecified = true;
	}
	else if(name == "SystemCreationClassName")
	{
		node.SetValue(SystemCreationClassName);
	}
	else if(name == "SystemName")
	{
		node.SetValue(SystemName);
	}
	else if(name == "CreationClassName")
	{
		node.SetValue(CreationClassName);
	}
	else if(name == "Name")
	{
		node.SetValue(Name);
	}
}

void CIM_ServiceAccessPoint::InvokeRequestStateChange(RequestStateChange_INPUT &input, RequestStateChange_OUTPUT &output, const WsmanClient *cl) const
{
	Invoke("RequestStateChange", &input, &output, cl);
}
const string CIM_ServiceAccessPoint::CLASS_NAME = "CIM_ServiceAccessPoint";
const string CIM_ServiceAccessPoint::CLASS_URI = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ServiceAccessPoint";
const string CIM_ServiceAccessPoint::CLASS_NS = "http://schemas.dmtf.org/wbem/wscim/1/cim-schema/2/CIM_ServiceAccessPoint";
const string CIM_ServiceAccessPoint::CLASS_NS_PREFIX = "";
