/* powerpc64le-darwin.macho-fold.h
   created from powerpc64le-darwin.macho-fold.bin, 6512 (0x1970) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2020 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2020 Laszlo Molnar
   Copyright (C) 2000-2020 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_POWERPC64LE_DARWIN_MACHO_FOLD_SIZE    6512
#define STUB_POWERPC64LE_DARWIN_MACHO_FOLD_ADLER32 0xe4f7c367
#define STUB_POWERPC64LE_DARWIN_MACHO_FOLD_CRC32   0xd9c156f2

unsigned char stub_powerpc64le_darwin_macho_fold[6512] = {
/* 0x0000 */   8,  0,128,124,105,  0,  0, 72,208,  0,  6, 40, 32,  0,194, 76,
/* 0x0010 */ 191,240,132, 84, 32,  0,194, 77, 16,  0,  0, 60, 64,  0,  4,124,
/* 0x0020 */   8,  0,128, 65,120,  3,  4,124, 32,  1,165, 56,120, 27,103,124,
/* 0x0030 */ 252,255, 99, 56,166,  3,137,124, 28,  0,  0, 72,186,  2, 96, 85,
/* 0x0040 */  80,  0,  3,124, 20, 58,  0,124,186,  1, 11, 80,  0,  0, 99,145,
/* 0x0050 */  32,  0, 64, 79,  4,  0, 99,133,190, 85, 96, 85, 64, 40,  0,124,
/* 0x0060 */ 220,255,194, 65,240,255, 32, 67, 32,  0,128, 78,144,  0, 33, 56,
/* 0x0070 */   0,  0, 32, 57,252,255, 33,149,120, 11, 41,124,166,  2,  8,125,
/* 0x0080 */ 248,255,159,128, 80,248,100,124, 24,  0,195,128,  0,  8,  6, 40,
/* 0x0090 */   8,  0,129, 65,  0,  8,192, 56,120, 11, 61,124, 80,  8, 38,124,
/* 0x00a0 */ 120, 11, 37,124,113,255, 33,248,120,251,231,127,105,  6,  0, 72,
/* 0x00b0 */ 120,235,161,127,  0,  0,  3,128,166,  3,  9,124,136,  0,  3,128,
/* 0x00c0 */  32,241, 15,124,140,  0,  3,128,166,  3,  1,124,144,  0,  3,128,
/* 0x00d0 */ 166,  3,  8,124, 24,  0,131,184,  8,  0,  3,128, 16,  0, 67,128,
/* 0x00e0 */  20,  0, 99,128, 32,  4,128, 78,120, 51,199,124,  0,  0,192, 56,
/* 0x00f0 */ 153,  0,  0, 56, 16,  0,  0, 72,120, 67,  9,125,  0,  0,  0, 57,
/* 0x0100 */ 197,  0,  0, 56,  2,  0,  0, 68,255,255, 96, 56, 32,  0,128, 78,
/* 0x0110 */   1,  0,  0, 56,240,255,255, 75,  3,  0,  0, 56,232,255,255, 75,
/* 0x0120 */   5,  0,  0, 56,224,255,255, 75,  6,  0,  0, 56,216,255,255, 75,
/* 0x0130 */  74,  0,  0, 56,208,255,255, 75,112,255,193,249,120,255,225,249,
/* 0x0140 */ 128,255,  1,250,136,255, 33,250,144,255, 65,250,152,255, 97,250,
/* 0x0150 */ 160,255,129,250,168,255,161,250,176,255,193,250,184,255,225,250,
/* 0x0160 */ 192,255,  1,251,200,255, 33,251,208,255, 65,251,216,255, 97,251,
/* 0x0170 */ 224,255,129,251,232,255,161,251,240,255,193,251,248,255,225,251,
/* 0x0180 */  16,  0,  1,248, 32,  0,128, 78,112,255,193,233,120,255,225,233,
/* 0x0190 */ 128,255,  1,234,136,255, 33,234,144,255, 65,234,152,255, 97,234,
/* 0x01a0 */ 160,255,129,234,168,255,161,234,176,255,193,234,184,255,225,234,
/* 0x01b0 */ 192,255,  1,235,200,255, 33,235,208,255, 65,235,216,255, 97,235,
/* 0x01c0 */ 224,255,129,235, 16,  0,  1,232,232,255,161,235,166,  3,  8,124,
/* 0x01d0 */ 240,255,193,235,248,255,225,235, 32,  0,128, 78,  8,  0,  3,233,
/* 0x01e0 */   0,  0, 67,233, 64, 40,170,127, 40,  0,220, 65,255,255, 37, 57,
/* 0x01f0 */ 255,255, 72, 57,255,255,132, 56, 20, 74, 40,125, 80, 72, 42,125,
/* 0x0200 */ 166,  3, 41,125,  0,  0,165, 47, 32,  0,158, 64, 40,  0,  0, 72,
/* 0x0210 */ 166,  2,  8,124, 16,  0,  1,248,145,255, 33,248,127,  0, 96, 56,
/* 0x0220 */ 241,254,255, 75,  0,  0,  0, 96,  1,  0, 42,141,  1,  0, 36,157,
/* 0x0230 */ 248,255,  0, 66,  8,  0, 35,233, 20, 42, 41,125,  8,  0, 35,249,
/* 0x0240 */   0,  0, 35,233, 80, 72,165,124,  0,  0,163,248, 32,  0,128, 78,
/* 0x0250 */   0,  0,  0,  0,  0,  0,  0,  1,128,  0,  0,  0,166,  2,  8,124,
/* 0x0260 */  16,  0,  1,248, 38,  0,128,125,224,255,129,251,232,255,161,251,
/* 0x0270 */ 240,255,193,251,248,255,225,251,  8,  0,129,145, 97,255, 33,248,
/* 0x0280 */   0,  0, 36,233,  0,  0,169, 47, 92,  1,158, 65,120, 51,220,124,
/* 0x0290 */ 120, 43,189,124,120, 35,159,124,120, 27,126,124,  0,  0, 38, 46,
/* 0x02a0 */ 120,243,195,127,112,  0,129, 56, 12,  0,160, 56, 49,255,255, 75,
/* 0x02b0 */ 112,  0, 33,129,  0,  0,169, 47, 40,  0,158, 64,116,  0, 33,129,
/* 0x02c0 */  88, 33, 64, 61, 85, 80, 74, 97,  0, 80,137,127, 32,  0,222, 64,
/* 0x02d0 */   0,  0, 62,233,  0,  0,169, 47, 12,  1,254, 65, 16,  0,  0, 72,
/* 0x02e0 */ 116,  0,161,128,  0,  0,165, 47, 16,  0,254, 64,127,  0, 96, 56,
/* 0x02f0 */  33,254,255, 75,  0,  0,  0, 96, 64, 40,137,127,240,255,220, 65,
/* 0x0300 */   0,  0, 95,233, 64, 80,169,127,228,255,221, 65, 64, 40,137,127,
/* 0x0310 */ 164,  0,157, 64,124,  0, 33,145,  8,  0,126,232,120, 43,164,124,
/* 0x0320 */   8,  0,191,232,124,  0,193, 56,120,  0,225,136, 40,  0, 65,248,
/* 0x0330 */   0,  0, 61,233, 16,  0,125,233,166,  3, 41,125,  8,  0, 93,232,
/* 0x0340 */  33,  4,128, 78, 40,  0, 65,232,  0,  0,163, 47,160,255,222, 64,
/* 0x0350 */ 112,  0,129,128,124,  0, 33,129,  0, 32,137,127,144,255,222, 64,
/* 0x0360 */ 121,  0,193,136,  0,  0,166, 47, 44,  0,158, 65, 40,  0,146, 65,
/* 0x0370 */   8,  0,127,232,122,  0,161,136, 40,  0, 65,248,  0,  0, 60,233,
/* 0x0380 */  16,  0,124,233,166,  3, 41,125,  8,  0, 92,232, 33,  4,128, 78,
/* 0x0390 */  40,  0, 65,232,116,  0,  1,129,  8,  0, 94,233, 20, 66, 74,125,
/* 0x03a0 */   8,  0, 94,249,  0,  0, 62,233, 80, 72, 40,125,  0,  0, 62,249,
/* 0x03b0 */  16,  0,  0, 72,120,243,195,127,  8,  0,159,232, 33,254,255, 75,
/* 0x03c0 */ 112,  0,  1,129,  8,  0, 95,233, 20, 66, 74,125,  8,  0, 95,249,
/* 0x03d0 */   0,  0, 63,233, 80, 72, 40,125,  0,  0, 63,249,  0,  0,169, 47,
/* 0x03e0 */ 192,254,158, 64,160,  0, 33, 56, 16,  0,  1,232,  8,  0,129,129,
/* 0x03f0 */ 166,  3,  8,124,224,255,129,235,232,255,161,235,240,255,193,235,
/* 0x0400 */ 248,255,225,235, 32,129,144,125, 32,  0,128, 78,  0,  0,  0,  0,
/* 0x0410 */   0,  0,  0,  3,128,  4,  0,  0,166,  2,  8,124, 16,  0,  1,248,
/* 0x0420 */  38,  0,128,125,120,255,225,249,128,255,  1,250,136,255, 33,250,
/* 0x0430 */ 144,255, 65,250,152,255, 97,250,160,255,129,250,168,255,161,250,
/* 0x0440 */ 176,255,193,250,184,255,225,250,192,255,  1,251,200,255, 33,251,
/* 0x0450 */ 208,255, 65,251,216,255, 97,251,224,255,129,251,232,255,161,251,
/* 0x0460 */ 240,255,193,251,248,255,225,251,  8,  0,129,145,241,254, 33,248,
/* 0x0470 */ 120, 27,123,124,120, 75, 53,125, 28,  0,227, 59, 16,  0, 35,129,
/* 0x0480 */   0,  0,137, 47,140,  1,158, 65,120, 35,153,124,120, 43,184,124,
/* 0x0490 */ 120, 51,215,124,120, 59,244,124,120, 67, 22,125,  0,  0,160, 59,
/* 0x04a0 */   0,  0, 96, 58,  0,  0, 37, 46,  0,  0, 64, 59,  0,  0,128, 59,
/* 0x04b0 */  18,  0, 64, 58,  0,  0, 95,129,  1,  0,138, 43, 12,  1,158, 64,
/* 0x04c0 */  36,  0, 63,129,112,  0, 33,249, 24,  0, 63,130,120,  0, 33,250,
/* 0x04d0 */  28,  0, 31,130, 20,130, 17,126,228,  4, 47,122, 32,  5, 49,122,
/* 0x04e0 */  21, 74, 49,126, 52,  1,130, 65, 16,  0,146, 64,  0,  0,169, 47,
/* 0x04f0 */  64,  1,158, 65, 48,  1,  0, 72,120,187,231,126,  0,  0,169, 47,
/* 0x0500 */ 100,  1,158, 64,255,255,224, 56, 92,  1,  0, 72, 36,  0, 63,129,
/* 0x0510 */   0,  0,137, 47, 40,  0,158, 65, 32,  0, 63,129,  0,  0,137, 47,
/* 0x0520 */   8,  0,158, 64,  0,  0,244,249,120,195,  3,127,112,  0,129, 56,
/* 0x0530 */ 120,179,197,126,120,171,166,126, 37,253,255, 75,208,  0,209,127,
/* 0x0540 */  33,  5,222,123, 24,  0,130, 65, 20,138, 47,125,255,255, 41, 57,
/* 0x0550 */ 166,  3,201,127,  1,  0,137,159,252,255,  0, 66,  0,  0,177, 47,
/* 0x0560 */  44,  0,158, 65,120,123,227,125,120,139, 36,126, 46,  0,191,232,
/* 0x0570 */ 193,251,255, 75,  0,  0,  0, 96,  0,  0,163, 47, 16,  0,254, 65,
/* 0x0580 */ 127,  0, 96, 56,141,251,255, 75,  0,  0,  0, 96, 20,138,222,127,
/* 0x0590 */  20,242,239,125, 64,120,176,127, 88,  0,157, 64,120,123,227,125,
/* 0x05a0 */  80,128,143,124, 44,  0,191,128, 18, 16,192, 56,255,255,224, 56,
/* 0x05b0 */ 120,211, 72,127, 69,251,255, 75,  0,  0,  0, 96,  0, 24,175,127,
/* 0x05c0 */  48,  0,254, 65,188,255,255, 75,252,255, 74, 57,  1,  0,138, 43,
/* 0x05d0 */  32,  0,157, 65,  8,  0, 63,129,  1,  0,137, 47, 20,  0,158, 64,
/* 0x05e0 */  12,  0, 63,129, 40,  0,137, 47,  8,  0,158, 64, 16,  0,127, 58,
/* 0x05f0 */   1,  0, 93, 57, 32,  0, 93,121,  4,  0, 63,129, 20, 74,255,127,
/* 0x0600 */  16,  0, 59,129, 64, 80,137,127,172,254,157, 65,156,  0,  0, 72,
/* 0x0610 */   0,  0, 96, 58,148,  0,  0, 72,124,  0,146, 64,120,211, 94,127,
/* 0x0620 */ 108,255,255, 75,120,187,231,126,120,147, 70,126, 12,  0,  0, 72,
/* 0x0630 */  18, 16,192, 56,255,255,224, 56, 32,  0, 31,129, 20,202,  8,125,
/* 0x0640 */ 120,123,227,125,120,139, 36,126,  3,  0,160, 56, 32,  0,  8,121,
/* 0x0650 */ 169,250,255, 75,  0,  0,  0, 96,  0, 24,175,127,224,254,254, 65,
/* 0x0660 */  32,255,255, 75, 32,  0, 31,129, 20,202,  8,125,120,123,227,125,
/* 0x0670 */ 120,139, 36,126,  3,  0,160, 56, 18, 16,192, 56, 32,  0,  8,121,
/* 0x0680 */ 121,250,255, 75,  0,  0,  0, 96,  0, 24,175,127,128,254,254, 65,
/* 0x0690 */ 240,254,255, 75, 36,  0, 63,129,120,211, 94,127,  0,  0,137, 47,
/* 0x06a0 */ 188,254,158, 65,116,254,255, 75,120,155, 99,126, 16,  1, 33, 56,
/* 0x06b0 */  16,  0,  1,232,  8,  0,129,129,166,  3,  8,124,120,255,225,233,
/* 0x06c0 */ 128,255,  1,234,136,255, 33,234,144,255, 65,234,152,255, 97,234,
/* 0x06d0 */ 160,255,129,234,168,255,161,234,176,255,193,234,184,255,225,234,
/* 0x06e0 */ 192,255,  1,235,200,255, 33,235,208,255, 65,235,216,255, 97,235,
/* 0x06f0 */ 224,255,129,235,232,255,161,235,240,255,193,235,248,255,225,235,
/* 0x0700 */  32,129,144,125, 32,  0,128, 78,  0,  0,  0,  0,  0,  0,  0,  3,
/* 0x0710 */ 128, 17,  0,  0,166,  2,  8,124, 16,  0,  1,248,216,255, 97,251,
/* 0x0720 */ 224,255,129,251,232,255,161,251,240,255,193,251,248,255,225,251,
/* 0x0730 */  49,255, 33,248,  8,  1,129,248,120, 43,191,124,120, 51,222,124,
/* 0x0740 */ 120, 59,253,124,120, 67, 28,125,120, 75, 59,125, 24,  0,195, 56,
/* 0x0750 */ 120,  0,193,248,  8,  1, 65,233,232,255, 74, 57,112,  0, 65,249,
/* 0x0760 */ 136,  0,161,248, 24,  0, 35,129,128,  0, 33,249,144,  0, 65,249,
/* 0x0770 */ 152,  0,193,248,112,  0, 97, 56,128,  0,129, 56,120, 59,229,124,
/* 0x0780 */   0,  0,192, 56,217,250,255, 75,120,251,227,127,  0,  0,128, 56,
/* 0x0790 */ 144,  0,161, 56,255,255,192, 56,120,219,103,127,120,235,168,127,
/* 0x07a0 */ 120,227,137,127,117,252,255, 75,120, 27,124,124, 28,  0, 63, 57,
/* 0x07b0 */  16,  0, 31,129,  0,  0,168, 47, 64,  1,158, 65, 28,  0, 95,129,
/* 0x07c0 */  14,  0,138, 47, 40,  0,158, 65,  0,  0, 64, 57,255,255,  8, 57,
/* 0x07d0 */  32,  0,  8,121,  1,  0,  8, 57,166,  3,  9,125,  8,  1,  0, 72,
/* 0x07e0 */   0,  0,  9,129, 14,  0,136, 47,252,  0,158, 64,  8,  0,105,232,
/* 0x07f0 */  20, 26,105,124,  0,  0,128, 56,  0,  0,160, 56, 37,249,255, 75,
/* 0x0800 */   0,  0,  0, 96,120, 27,125,124,  0,  0,131, 47, 48,  0,220, 65,
/* 0x0810 */   0,  0,128, 59,254,202, 96, 63,190,186,123, 99,120,235,163,127,
/* 0x0820 */ 120,251,228,127,120,243,197,127,120,227,134,127,189,248,255, 75,
/* 0x0830 */   0,  0,  0, 96,  0, 24,190,127, 16,  0,254, 65,127,  0, 96, 56,
/* 0x0840 */ 209,248,255, 75,  0,  0,  0, 96,  0,  0, 63,129,  0,216,137,127,
/* 0x0850 */  96,  0,158, 64,  8,  0, 63, 57,  4,  0, 95,129,  0,  0,170, 47,
/* 0x0860 */  80,  0,158, 65,  8,  0, 31,129, 18,  0,136, 47, 28,  0,158, 64,
/* 0x0870 */  16,  0,  0, 72,  0,  0, 73,129, 18,  0,138, 47, 40,  0,158, 64,
/* 0x0880 */   8,  0,137,131,152,255,255, 75,255,255, 74, 57, 32,  0, 74,121,
/* 0x0890 */ 100, 23, 72,121,228, 38, 74,121, 20, 82,  8,125, 28,  0,  8, 57,
/* 0x08a0 */  20, 66, 31,125, 20,  0, 41, 57, 64, 64,169,127,200,255,158, 64,
/* 0x08b0 */ 120,251,227,127,120,227,132,127,  0,  0,160, 56,120,235,166,127,
/* 0x08c0 */   0,  0,224, 56,  0,  0,  0, 57,  0,  0, 32, 57, 77,251,255, 75,
/* 0x08d0 */ 120, 27,124,124,120,235,163,127, 81,248,255, 75,  0,  0,  0, 96,
/* 0x08e0 */  24,  0,  0, 72,  1,  0, 74, 57, 32,  0, 74,121,  4,  0,  9,129,
/* 0x08f0 */  20, 66, 41,125,236,254,  0, 66,120,227,131,127,208,  0, 33, 56,
/* 0x0900 */  16,  0,  1,232,166,  3,  8,124,216,255, 97,235,224,255,129,235,
/* 0x0910 */ 232,255,161,235,240,255,193,235,248,255,225,235, 32,  0,128, 78,
/* 0x0920 */   0,  0,  0,  0,  0,  0,  0,  1,128,  5,  0,  0,  0,  0,  0,  0,
/* 0x0930 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0940 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0950 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0960 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0970 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0980 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0990 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x09f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0a90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0aa0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ab0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ac0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ad0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ae0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0af0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0b90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ba0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bc0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0be0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0bf0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0c90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ca0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0cb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0cc0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0cd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ce0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0cf0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0d90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0da0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0db0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0dc0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0dd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0de0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0df0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0e90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ea0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0eb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ec0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ed0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ee0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ef0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f00 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f10 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f20 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f30 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f40 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f50 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f60 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f70 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0f90 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fa0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fb0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fc0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fd0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0fe0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0ff0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1000 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1010 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1020 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1030 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1040 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1050 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1060 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1070 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1080 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1090 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x10f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1100 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1110 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1120 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1130 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1140 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1150 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1160 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1170 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1180 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1190 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x11f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1200 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1210 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1220 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1230 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1240 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1250 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1260 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1270 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1280 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1290 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x12f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1300 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1310 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1320 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1330 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1340 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1350 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1360 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1370 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1380 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1390 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x13a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x13b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x13c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x13d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x13e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x13f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1400 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1410 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1420 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1430 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1440 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1450 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1460 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1470 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1480 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1490 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x14a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x14b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x14c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x14d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x14e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x14f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1500 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1510 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1520 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1530 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1540 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1550 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1560 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1570 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1580 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1590 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x15a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x15b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x15c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x15d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x15e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x15f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1600 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1610 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1620 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1630 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1640 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1650 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1660 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1670 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1680 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1690 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x16a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x16b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x16c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x16d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x16e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x16f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1700 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1710 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1720 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1730 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1740 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1750 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1760 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1770 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1780 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1790 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x17a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x17b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x17c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x17d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x17e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x17f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1800 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1810 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1820 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1830 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1840 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1850 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1860 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1870 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1880 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1890 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18a0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18b0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18c0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18d0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18e0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x18f0 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1900 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1910 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1920 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1930 */ 220,129,  4,  8,  0,  0,  0,  0,  0, 25,  5,  8,  0,  0,  0,  0,
/* 0x1940 */  92,130,  4,  8,  0,  0,  0,  0,  0, 25,  5,  8,  0,  0,  0,  0,
/* 0x1950 */  24,132,  4,  8,  0,  0,  0,  0,  0, 25,  5,  8,  0,  0,  0,  0,
/* 0x1960 */  20,135,  4,  8,  0,  0,  0,  0,  0, 25,  5,  8,  0,  0,  0,  0
};
