/***************************************************************************
                dcguiutils.cpp  -  Valknut Utility Functions
                             -------------------
    begin                : Thu Jul 3 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dcguiutils.h"

#include <dclib/core/cstring.h>
#include <dclib/cutils.h>

#include <QComboBox>
#include <Q3ListView>
#include <QTreeView>

/*
 * Needed to get the number of columns in the QTreeView
 */
#include <QHeaderView>

#include "dcconfig.h"

/* theme detection */
#include <QApplication>
#include <QStyle>
#include <QStyleFactory>
#include <QMetaObject>
#include <QStringList>

/** */
DCGuiUtils::DCGuiUtils()
{
	// nothing
}

/** */
DCGuiUtils::~DCGuiUtils()
{
	// nothing
}

/** */
QString DCGuiUtils::GetSizeString( const ulonglong size )
{
	/* could check if g_pConfig is null and use default, but not really worth it */
	return QString::fromAscii( CUtils::GetSizeString( size, g_pConfig->GetUnit() ).Data() );
}

/** */
void DCGuiUtils::AddEncodings( QComboBox * combobox )
{
	combobox->addItem("UTF-8");
	combobox->addItem("WINDOWS-1252");
	combobox->addItem("WINDOWS-1251");
	combobox->addItem("WINDOWS-1250");
	combobox->addItem("WINDOWS-1256");
	combobox->addItem("WINDOWS-1257");
	combobox->addItem("ISO-8859-1");
	combobox->addItem("ISO-8859-2");
	combobox->addItem("ISO-8859-7");
	combobox->addItem("ISO-8859-8");
	combobox->addItem("ISO-8859-9");
	combobox->addItem("ISO-2022-JP");
	combobox->addItem("SHIFT-JIS");
	combobox->addItem("CP949");
	combobox->addItem("KOI8-R");
	combobox->addItem("GB18030");
	combobox->addItem("TIS-620");
}

/** */
QString DCGuiUtils::SortOrderName( const Qt::SortOrder order )
{
	if ( order == Qt::DescendingOrder )
	{
		return QString::fromAscii("Descending");
	}
	else
	{
		return QString::fromAscii("Ascending");
	}
}

/** */
Qt::SortOrder DCGuiUtils::SortOrderFromName( const QString name )
{
	if ( name == "Descending" )
	{
		return Qt::DescendingOrder;
	}
	else
	{
		return Qt::AscendingOrder;
	}
}

/** */
void DCGuiUtils::AdjustColumnWidths( Q3ListView * view, int oldsize )
{
	bool updates = view->updatesEnabled();
	if ( updates )
	{
		view->setUpdatesEnabled(false);
	}
	
	// need floats to reduce rounding errors
	float newwidth = (float) view->width();
	float oldsize_f = (float) oldsize;
	
	int newcolwidth;
	for ( int i = 0; i < view->columns(); i++ )
	{
		newcolwidth = (int) ( ((float) view->columnWidth(i)) * newwidth / oldsize_f );
		if ( newcolwidth < 10 )
		{
			newcolwidth = 10;
		}
		
		view->setColumnWidth( i, newcolwidth );
	}
	
	if ( updates )
	{
		view->setUpdatesEnabled(true);
	}
}

/** */
void DCGuiUtils::AdjustColumnWidths( QTreeView * view, int oldsize )
{
	bool updates = view->updatesEnabled();
	if ( updates )
	{
		view->setUpdatesEnabled(false);
	}
	
	// need floats to reduce rounding errors
	float newwidth = (float) view->width();
	float oldsize_f = (float) oldsize;
	
	int newcolwidth;
	for ( int i = 0; i < view->header()->count(); i++ )
	{
		if ( view->header()->isSectionHidden(i) )
		{
			continue;
		}
		
		newcolwidth = (int) ( ((float) view->columnWidth(i)) * newwidth / oldsize_f );
		if ( newcolwidth < 10 )
		{
			newcolwidth = 10;
		}
		
		view->setColumnWidth( i, newcolwidth );
	}
	
	if ( updates )
	{
		view->setUpdatesEnabled(true);
	}
}

/** */
int DCGuiUtils::SelectedItems( Q3ListView * view, QList<Q3ListViewItem*> & list )
{
	Q3ListViewItemIterator it( view );

	for ( ; it.current(); it++ )
	{
		if ( it.current()->isSelected() )
		{
			list.append(it.current());
		}
	}

	return list.count();
}

/** */
QString DCGuiUtils::DetectAppStyleKey()
{
	QString key;
	
	QStyle * appstyle = QApplication::style();
	
	if ( appstyle )
	{
		QStringList keys = QStyleFactory::keys();
		
		for ( QStringList::const_iterator it = keys.constBegin(); it != keys.constEnd(); ++it )
		{
			QStyle * temp = QStyleFactory::create( *it );
			if ( temp )
			{
				QString tempclass = temp->metaObject()->className();
				delete temp;
				
				if ( tempclass == appstyle->metaObject()->className() )
				{
					key = *it;
					break;
				}
			}
		}
	}
	
	return key;
}
