/***************************************************************************
      filteronlyproxy.h  -  Proxy model for filtering without sorting
                             -------------------
    begin                : Tue Nov 11 2008
    copyright            : (C) 2008 by Edward Sheldrake
    email                : ejs1920@yahoo.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#if !defined(FILTERONLYPROXY_H)
#define FILTERONLYPROXY_H

/**
 * @author Edward Sheldrake
 *
 * It's QSortFilterProxyModel with the sorting disabled and
 * handled by the source model.
 */

#include <QSortFilterProxyModel>

class FilterOnlyProxy: public QSortFilterProxyModel {
Q_OBJECT

public:
	/** Constructor */
	FilterOnlyProxy( QObject * parent = 0 );
	/** Destructor */
	virtual ~FilterOnlyProxy();
	
	/** Sort the model - just calls the source model sort() function */
	virtual void sort( int column, Qt::SortOrder order = Qt::AscendingOrder );
	
protected:
	/** Also disabled just in case, just compares the model index rows */
	virtual bool lessThan( const QModelIndex & left, const QModelIndex & right ) const;
};

#endif /* FILTERONLYPROXY_H */
