# BuildPlugin.cmake - Copyright (c) 2017-2019 Tobias Junghans
#
# description: build Veyon plugin
# usage: BUILD_PLUGIN(<NAME> <SOURCES>)

MACRO(BUILD_PLUGIN PLUGIN_NAME)
	SET(PLUGIN_SOURCES ${ARGN})

	ADD_LIBRARY(${PLUGIN_NAME} MODULE ${PLUGIN_SOURCES})

	TARGET_INCLUDE_DIRECTORIES(${PLUGIN_NAME} PRIVATE ${CMAKE_CURRENT_BINARY_DIR} ${CMAKE_CURRENT_SOURCE_DIR})
	TARGET_LINK_LIBRARIES(${PLUGIN_NAME} veyon-core)

	SET_TARGET_PROPERTIES(${PLUGIN_NAME} PROPERTIES PREFIX "")
	SET_TARGET_PROPERTIES(${PLUGIN_NAME} PROPERTIES LINK_FLAGS "-Wl,-no-undefined")
	INSTALL(TARGETS ${PLUGIN_NAME} LIBRARY DESTINATION ${VEYON_INSTALL_PLUGIN_DIR})

	COTIRE_VEYON(${PLUGIN_NAME})
ENDMACRO(BUILD_PLUGIN)

