#include	<stdio.h>
#include	"defs.h"

/* jsubfont */
/*#include	"jsub.h"*/

char *jsf_names[] = {
    "",
    "jsy",
    "jroma",
    "jhira",
    "jkata",
    "jgreek",
    "jrussian",
    "jkeisen",
    "jka",
    "jkb",
    "jkc",
    "jkd",
    "jke",
    "jkf",
    "jkg",
    "jkh",
    "jki",
    "jkj",
    "jkk",
    "jkl",
    "jkm",
    "jkn",
    "jko",
    "jkp",
    "jkq",
    "jkr",
    "jks",
    "jkt",
    "jku",
    "jkv",
    "jkw",
    "jkx",
    "jky",
    "jkz",
    NULL
};

char *
jsubfontname(f)
{
    return (jsf_names[f]);
}

#define	makejis(k,t)	((k+0x20)*256+t+0x20)

compute_jis(f, c)
int f, c;
{
    register int n;

    if (f <= 7) {
	if (f == 1) {
	    if (c >= 100) {
		return (makejis(2, c-100));
	    } else {
		return (makejis(1, c));
	    }
	} else if (f == 2) {
	    return (makejis(3, c-32));
	} else {
	    return (makejis(f+1, c));
	}
    } else if (f <= 19) {	/* Daiichi Suijun */
	n = (f-8)*256+c;
	return (makejis((n/94)+16, (n%94)+1));
    } else {			/* Daini Suijun */
	n = (f-20)*256+c;
	return (makejis((n/94)+48, (n%94)+1));
    }
}

compute_fc(ku, ten, f, c)
int ku, ten;
int *f, *c;
{
    register int n;

    *f = 1;
    *c = 1;
    if (ku <= 0 || (9 <= ku && ku <= 15) || ku > 84) {
	return (FALSE);
    }
    if (ten < 1 || ten > 94) {
	return (FALSE);
    }
    if (ku <= 8) {
	if (ku == 1) {
	    *f = 1;
	    *c = ten;
	} else if (ku == 2) {
	    *f = 1;
	    *c = ten+100;
	} else if (ku == 3) {
	    *f = 2;
	    *c = ten+32;
	} else {
	    *f = ku-1;
	    *c = ten;
	}
    } else if (ku <= 47) {	/* Daiich Suijun */
	n = (ku-16)*94+ten-1;
	*f = (n/256)+8;
	*c = n%256;
    } else {			/* Daini Suijun */
	n = (ku-48)*94+ten-1;
	*f = (n/256)+20;
	*c = n%256;
    }
    return (TRUE);
}
