#include <bdsg/graph_proxy.hpp>
#include <bdsg/internal/base_packed_graph.hpp>
#include <bdsg/internal/graph_proxy_handle_graph_fragment.classfragment>
#include <bdsg/internal/graph_proxy_mutable_path_deletable_handle_graph_fragment.classfragment>
#include <bdsg/internal/graph_proxy_path_handle_graph_fragment.classfragment>
#include <bdsg/internal/graph_proxy_serializable_handle_graph_fragment.classfragment>
#include <bdsg/internal/mapped_structs.hpp>
#include <functional>
#include <handlegraph/types.hpp>
#include <ios>
#include <istream>
#include <memory>
#include <ostream>
#include <sstream> // __str__
#include <streambuf>
#include <string>
#include <string_view>
#include <unordered_set>
#include <utility>
#include <vector>

#include <functional>
#include <pybind11/pybind11.h>
#include <string>
#include <bdsg/internal/binder_hook_compile.hpp>
#include <pybind11/stl.h>
#include <pybind11/stl_bind.h>
#include <pybind11/functional.h>
#include <fstream>


#ifndef BINDER_PYBIND11_TYPE_CASTER
	#define BINDER_PYBIND11_TYPE_CASTER
	PYBIND11_DECLARE_HOLDER_TYPE(T, std::shared_ptr<T>)
	PYBIND11_DECLARE_HOLDER_TYPE(T, T*)
	PYBIND11_MAKE_OPAQUE(std::shared_ptr<void>)
#endif

void bind_bdsg_graph_proxy(std::function< pybind11::module &(std::string const &namespace_) > &M)
{
	{ // bdsg::GraphProxy file:bdsg/graph_proxy.hpp line:60
		pybind11::class_<bdsg::GraphProxy<bdsg::BasePackedGraph<>>, std::shared_ptr<bdsg::GraphProxy<bdsg::BasePackedGraph<>>>, handlegraph::MutablePathDeletableHandleGraph, handlegraph::SerializableHandleGraph> cl(M("bdsg"), "GraphProxy_bdsg_BasePackedGraph_t", "");
		cl.def("has_node", (bool (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(long long) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::has_node, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::has_node(long long) const --> bool", pybind11::arg("node_id"));
		cl.def("get_handle", [](bdsg::GraphProxy<bdsg::BasePackedGraph<>> const &o, const long long & a0) -> handlegraph::handle_t { return o.get_handle(a0); }, "", pybind11::arg("node_id"));
		cl.def("get_handle", (struct handlegraph::handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const long long &, bool) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_handle, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_handle(const long long &, bool) const --> struct handlegraph::handle_t", pybind11::arg("node_id"), pybind11::arg("is_reverse"));
		cl.def("get_id", (long long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_id, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_id(const struct handlegraph::handle_t &) const --> long long", pybind11::arg("handle"));
		cl.def("get_is_reverse", (bool (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_is_reverse, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_is_reverse(const struct handlegraph::handle_t &) const --> bool", pybind11::arg("handle"));
		cl.def("flip", (struct handlegraph::handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::flip, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::flip(const struct handlegraph::handle_t &) const --> struct handlegraph::handle_t", pybind11::arg("handle"));
		cl.def("get_length", (unsigned long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_length, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_length(const struct handlegraph::handle_t &) const --> unsigned long", pybind11::arg("handle"));
		cl.def("get_sequence", (std::string (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_sequence, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_sequence(const struct handlegraph::handle_t &) const --> std::string", pybind11::arg("handle"));
		cl.def("get_node_count", (unsigned long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)() const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_node_count, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_node_count() const --> unsigned long");
		cl.def("min_node_id", (long long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)() const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::min_node_id, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::min_node_id() const --> long long");
		cl.def("max_node_id", (long long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)() const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::max_node_id, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::max_node_id() const --> long long");
		cl.def("get_degree", (unsigned long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &, bool) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_degree, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_degree(const struct handlegraph::handle_t &, bool) const --> unsigned long", pybind11::arg("handle"), pybind11::arg("go_left"));
		cl.def("has_edge", (bool (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &, const struct handlegraph::handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::has_edge, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::has_edge(const struct handlegraph::handle_t &, const struct handlegraph::handle_t &) const --> bool", pybind11::arg("left"), pybind11::arg("right"));
		cl.def("get_edge_count", (unsigned long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)() const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_edge_count, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_edge_count() const --> unsigned long");
		cl.def("get_total_length", (unsigned long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)() const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_total_length, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_total_length() const --> unsigned long");
		cl.def("get_base", (char (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &, unsigned long) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_base, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_base(const struct handlegraph::handle_t &, unsigned long) const --> char", pybind11::arg("handle"), pybind11::arg("index"));
		cl.def("get_subsequence", (std::string (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &, unsigned long, unsigned long) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_subsequence, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_subsequence(const struct handlegraph::handle_t &, unsigned long, unsigned long) const --> std::string", pybind11::arg("handle"), pybind11::arg("index"), pybind11::arg("size"));
		cl.def("get_path_count", (unsigned long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)() const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_path_count, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_path_count() const --> unsigned long");
		cl.def("has_path", (bool (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const std::string &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::has_path, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::has_path(const std::string &) const --> bool", pybind11::arg("path_name"));
		cl.def("get_path_handle", (struct handlegraph::path_handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const std::string &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_path_handle, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_path_handle(const std::string &) const --> struct handlegraph::path_handle_t", pybind11::arg("path_name"));
		cl.def("get_path_name", (std::string (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_path_name, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_path_name(const struct handlegraph::path_handle_t &) const --> std::string", pybind11::arg("path_handle"));
		cl.def("get_is_circular", (bool (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_is_circular, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_is_circular(const struct handlegraph::path_handle_t &) const --> bool", pybind11::arg("path_handle"));
		cl.def("get_step_count", (unsigned long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_step_count, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_step_count(const struct handlegraph::path_handle_t &) const --> unsigned long", pybind11::arg("path_handle"));
		cl.def("get_step_count", (unsigned long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_step_count, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_step_count(const struct handlegraph::handle_t &) const --> unsigned long", pybind11::arg("handle"));
		cl.def("get_handle_of_step", (struct handlegraph::handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::step_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_handle_of_step, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_handle_of_step(const struct handlegraph::step_handle_t &) const --> struct handlegraph::handle_t", pybind11::arg("step_handle"));
		cl.def("get_path_handle_of_step", (struct handlegraph::path_handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::step_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_path_handle_of_step, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_path_handle_of_step(const struct handlegraph::step_handle_t &) const --> struct handlegraph::path_handle_t", pybind11::arg("step_handle"));
		cl.def("path_begin", (struct handlegraph::step_handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::path_begin, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::path_begin(const struct handlegraph::path_handle_t &) const --> struct handlegraph::step_handle_t", pybind11::arg("path_handle"));
		cl.def("path_end", (struct handlegraph::step_handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::path_end, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::path_end(const struct handlegraph::path_handle_t &) const --> struct handlegraph::step_handle_t", pybind11::arg("path_handle"));
		cl.def("path_back", (struct handlegraph::step_handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::path_back, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::path_back(const struct handlegraph::path_handle_t &) const --> struct handlegraph::step_handle_t", pybind11::arg("path_handle"));
		cl.def("path_front_end", (struct handlegraph::step_handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::path_front_end, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::path_front_end(const struct handlegraph::path_handle_t &) const --> struct handlegraph::step_handle_t", pybind11::arg("path_handle"));
		cl.def("has_next_step", (bool (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::step_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::has_next_step, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::has_next_step(const struct handlegraph::step_handle_t &) const --> bool", pybind11::arg("step_handle"));
		cl.def("has_previous_step", (bool (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::step_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::has_previous_step, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::has_previous_step(const struct handlegraph::step_handle_t &) const --> bool", pybind11::arg("step_handle"));
		cl.def("get_next_step", (struct handlegraph::step_handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::step_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_next_step, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_next_step(const struct handlegraph::step_handle_t &) const --> struct handlegraph::step_handle_t", pybind11::arg("step_handle"));
		cl.def("get_previous_step", (struct handlegraph::step_handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::step_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_previous_step, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_previous_step(const struct handlegraph::step_handle_t &) const --> struct handlegraph::step_handle_t", pybind11::arg("step_handle"));
		cl.def("steps_of_handle", [](bdsg::GraphProxy<bdsg::BasePackedGraph<>> const &o, const struct handlegraph::handle_t & a0) -> std::vector<handlegraph::step_handle_t> { return o.steps_of_handle(a0); }, "", pybind11::arg("handle"));
		cl.def("steps_of_handle", (class std::vector<handlegraph::step_handle_t> (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &, bool) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::steps_of_handle, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::steps_of_handle(const struct handlegraph::handle_t &, bool) const --> class std::vector<handlegraph::step_handle_t>", pybind11::arg("handle"), pybind11::arg("match_orientation"));
		cl.def("is_empty", (bool (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::is_empty, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::is_empty(const struct handlegraph::path_handle_t &) const --> bool", pybind11::arg("path_handle"));
		cl.def("get_sense", (enum handlegraph::PathSense (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_sense, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_sense(const struct handlegraph::path_handle_t &) const --> enum handlegraph::PathSense", pybind11::arg("handle"));
		cl.def("get_sample_name", (std::string (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_sample_name, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_sample_name(const struct handlegraph::path_handle_t &) const --> std::string", pybind11::arg("handle"));
		cl.def("get_locus_name", (std::string (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_locus_name, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_locus_name(const struct handlegraph::path_handle_t &) const --> std::string", pybind11::arg("handle"));
		cl.def("get_haplotype", (unsigned long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_haplotype, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_haplotype(const struct handlegraph::path_handle_t &) const --> unsigned long", pybind11::arg("handle"));
		cl.def("get_phase_block", (unsigned long (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_phase_block, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_phase_block(const struct handlegraph::path_handle_t &) const --> unsigned long", pybind11::arg("handle"));
		cl.def("get_subrange", (struct std::pair<unsigned long, unsigned long> (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &) const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_subrange, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_subrange(const struct handlegraph::path_handle_t &) const --> struct std::pair<unsigned long, unsigned long>", pybind11::arg("handle"));
		cl.def("create_handle", (struct handlegraph::handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const std::string &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::create_handle, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::create_handle(const std::string &) --> struct handlegraph::handle_t", pybind11::arg("sequence"));
		cl.def("create_handle", (struct handlegraph::handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const std::string &, const long long &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::create_handle, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::create_handle(const std::string &, const long long &) --> struct handlegraph::handle_t", pybind11::arg("sequence"), pybind11::arg("id"));
		cl.def("create_edge", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &, const struct handlegraph::handle_t &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::create_edge, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::create_edge(const struct handlegraph::handle_t &, const struct handlegraph::handle_t &) --> void", pybind11::arg("left"), pybind11::arg("right"));
		cl.def("apply_orientation", (struct handlegraph::handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::apply_orientation, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::apply_orientation(const struct handlegraph::handle_t &) --> struct handlegraph::handle_t", pybind11::arg("handle"));
		cl.def("divide_handle", (class std::vector<handlegraph::handle_t> (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &, const class std::vector<unsigned long> &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::divide_handle, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::divide_handle(const struct handlegraph::handle_t &, const class std::vector<unsigned long> &) --> class std::vector<handlegraph::handle_t>", pybind11::arg("handle"), pybind11::arg("offsets"));
		cl.def("optimize", [](bdsg::GraphProxy<bdsg::BasePackedGraph<>> &o) -> void { return o.optimize(); }, "");
		cl.def("optimize", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(bool)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::optimize, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::optimize(bool) --> void", pybind11::arg("allow_id_reassignment"));
		cl.def("apply_ordering", [](bdsg::GraphProxy<bdsg::BasePackedGraph<>> &o, const class std::vector<handlegraph::handle_t> & a0) -> bool { return o.apply_ordering(a0); }, "", pybind11::arg("order"));
		cl.def("apply_ordering", (bool (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const class std::vector<handlegraph::handle_t> &, bool)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::apply_ordering, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::apply_ordering(const class std::vector<handlegraph::handle_t> &, bool) --> bool", pybind11::arg("order"), pybind11::arg("compact_ids"));
		cl.def("set_id_increment", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const long long &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::set_id_increment, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::set_id_increment(const long long &) --> void", pybind11::arg("min_id"));
		cl.def("increment_node_ids", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(long long)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::increment_node_ids, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::increment_node_ids(long long) --> void", pybind11::arg("increment"));
		cl.def("increment_node_ids", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(long)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::increment_node_ids, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::increment_node_ids(long) --> void", pybind11::arg("increment"));
		cl.def("reassign_node_ids", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const class std::function<long long (const long long &)> &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::reassign_node_ids, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::reassign_node_ids(const class std::function<long long (const long long &)> &) --> void", pybind11::arg("get_new_id"));
		cl.def("destroy_path", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::destroy_path, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::destroy_path(const struct handlegraph::path_handle_t &) --> void", pybind11::arg("path"));
		cl.def("create_path_handle", [](bdsg::GraphProxy<bdsg::BasePackedGraph<>> &o, const std::string & a0) -> handlegraph::path_handle_t { return o.create_path_handle(a0); }, "", pybind11::arg("name"));
		cl.def("create_path_handle", (struct handlegraph::path_handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const std::string &, bool)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::create_path_handle, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::create_path_handle(const std::string &, bool) --> struct handlegraph::path_handle_t", pybind11::arg("name"), pybind11::arg("is_circular"));
		cl.def("append_step", (struct handlegraph::step_handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &, const struct handlegraph::handle_t &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::append_step, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::append_step(const struct handlegraph::path_handle_t &, const struct handlegraph::handle_t &) --> struct handlegraph::step_handle_t", pybind11::arg("path"), pybind11::arg("to_append"));
		cl.def("prepend_step", (struct handlegraph::step_handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &, const struct handlegraph::handle_t &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::prepend_step, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::prepend_step(const struct handlegraph::path_handle_t &, const struct handlegraph::handle_t &) --> struct handlegraph::step_handle_t", pybind11::arg("path"), pybind11::arg("to_prepend"));
		cl.def("rewrite_segment", (struct std::pair<struct handlegraph::step_handle_t, struct handlegraph::step_handle_t> (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::step_handle_t &, const struct handlegraph::step_handle_t &, const class std::vector<handlegraph::handle_t> &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::rewrite_segment, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::rewrite_segment(const struct handlegraph::step_handle_t &, const struct handlegraph::step_handle_t &, const class std::vector<handlegraph::handle_t> &) --> struct std::pair<struct handlegraph::step_handle_t, struct handlegraph::step_handle_t>", pybind11::arg("segment_begin"), pybind11::arg("segment_end"), pybind11::arg("new_segment"));
		cl.def("set_circularity", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::path_handle_t &, bool)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::set_circularity, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::set_circularity(const struct handlegraph::path_handle_t &, bool) --> void", pybind11::arg("path"), pybind11::arg("circular"));
		cl.def("destroy_handle", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::destroy_handle, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::destroy_handle(const struct handlegraph::handle_t &) --> void", pybind11::arg("handle"));
		cl.def("destroy_edge", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &, const struct handlegraph::handle_t &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::destroy_edge, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::destroy_edge(const struct handlegraph::handle_t &, const struct handlegraph::handle_t &) --> void", pybind11::arg("left"), pybind11::arg("right"));
		cl.def("truncate_handle", (struct handlegraph::handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct handlegraph::handle_t &, bool, unsigned long)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::truncate_handle, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::truncate_handle(const struct handlegraph::handle_t &, bool, unsigned long) --> struct handlegraph::handle_t", pybind11::arg("handle"), pybind11::arg("trunc_left"), pybind11::arg("offset"));
		cl.def("clear", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)()) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::clear, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::clear() --> void");
		cl.def("create_path", [](bdsg::GraphProxy<bdsg::BasePackedGraph<>> &o, const enum handlegraph::PathSense & a0, const std::string & a1, const std::string & a2, const unsigned long & a3, const unsigned long & a4, const struct std::pair<unsigned long, unsigned long> & a5) -> handlegraph::path_handle_t { return o.create_path(a0, a1, a2, a3, a4, a5); }, "", pybind11::arg("sense"), pybind11::arg("sample"), pybind11::arg("locus"), pybind11::arg("haplotype"), pybind11::arg("phase_block"), pybind11::arg("subrange"));
		cl.def("create_path", (struct handlegraph::path_handle_t (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const enum handlegraph::PathSense &, const std::string &, const std::string &, const unsigned long &, const unsigned long &, const struct std::pair<unsigned long, unsigned long> &, bool)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::create_path, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::create_path(const enum handlegraph::PathSense &, const std::string &, const std::string &, const unsigned long &, const unsigned long &, const struct std::pair<unsigned long, unsigned long> &, bool) --> struct handlegraph::path_handle_t", pybind11::arg("sense"), pybind11::arg("sample"), pybind11::arg("locus"), pybind11::arg("haplotype"), pybind11::arg("phase_block"), pybind11::arg("subrange"), pybind11::arg("is_circular"));
		cl.def("get_magic_number", (unsigned int (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)() const) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_magic_number, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::get_magic_number() const --> unsigned int");
		cl.def("deserialize", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const std::string &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::deserialize, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::deserialize(const std::string &) --> void", pybind11::arg("filename"));
		cl.def("serialize", (void (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const std::string &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::serialize, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::serialize(const std::string &) --> void", pybind11::arg("filename"));
		cl.def("assign", (struct bdsg::GraphProxy<class bdsg::BasePackedGraph<> > & (bdsg::GraphProxy<bdsg::BasePackedGraph<>>::*)(const struct bdsg::GraphProxy<class bdsg::BasePackedGraph<> > &)) &bdsg::GraphProxy<bdsg::BasePackedGraph<>>::operator=, "C++: bdsg::GraphProxy<bdsg::BasePackedGraph<>>::operator=(const struct bdsg::GraphProxy<class bdsg::BasePackedGraph<> > &) --> struct bdsg::GraphProxy<class bdsg::BasePackedGraph<> > &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("assign", (class handlegraph::MutablePathDeletableHandleGraph & (handlegraph::MutablePathDeletableHandleGraph::*)(const class handlegraph::MutablePathDeletableHandleGraph &)) &handlegraph::MutablePathDeletableHandleGraph::operator=, "C++: handlegraph::MutablePathDeletableHandleGraph::operator=(const class handlegraph::MutablePathDeletableHandleGraph &) --> class handlegraph::MutablePathDeletableHandleGraph &", pybind11::return_value_policy::automatic, pybind11::arg(""));
		cl.def("assign", (class handlegraph::SerializableHandleGraph & (handlegraph::SerializableHandleGraph::*)(const class handlegraph::SerializableHandleGraph &)) &handlegraph::SerializableHandleGraph::operator=, "C++: handlegraph::SerializableHandleGraph::operator=(const class handlegraph::SerializableHandleGraph &) --> class handlegraph::SerializableHandleGraph &", pybind11::return_value_policy::automatic, pybind11::arg(""));
	}
}
