/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.helper;

import com.sun.appserv.management.client.AppserverConnectionSource;
import com.sun.appserv.management.client.HandshakeCompletedListenerImpl;
import com.sun.appserv.management.client.TLSParams;
import com.sun.appserv.management.client.TrustStoreTrustManager;
import java.io.File;
import java.io.IOException;
import javax.net.ssl.HandshakeCompletedListener;

public class Connect {
    private Connect() {
    }

    public static AppserverConnectionSource connectTLS(String host, int port, String user, String userPassword, boolean promptForUnknownCertificate) throws IOException {
        TLSParams tlsParams = Connect.createTLSParams(null, promptForUnknownCertificate);
        return new AppserverConnectionSource("sun-as-rmi", host, port, user, userPassword, tlsParams, null);
    }

    public static AppserverConnectionSource connectNoTLS(String host, int port, String user, String userPassword) throws IOException {
        return new AppserverConnectionSource(host, port, user, userPassword, null);
    }

    public static File getDefaultTrustStore() {
        String homeDir = System.getProperty("user.home");
        String sep = System.getProperty("file.separator");
        return new File(homeDir + sep + ".asadmintruststore");
    }

    public static TLSParams createTLSParams(String trustStorePassword, boolean promptForNewCertificate) {
        return Connect.createTLSParams(null, trustStorePassword, promptForNewCertificate);
    }

    public static TLSParams createTLSParams(File trustStore, String trustStorePasswordIn, boolean promptForUnknownCertificate) {
        File trustStoreFile = trustStore == null ? Connect.getDefaultTrustStore() : trustStore;
        char[] trustStorePassword = (trustStorePasswordIn == null ? "changeit" : trustStorePasswordIn).toCharArray();
        HandshakeCompletedListenerImpl handshakeCompletedListener = new HandshakeCompletedListenerImpl();
        TrustStoreTrustManager trustMgr = new TrustStoreTrustManager(trustStoreFile, trustStorePassword);
        trustMgr.setPrompt(promptForUnknownCertificate);
        TLSParams tlsParams = new TLSParams(trustMgr, (HandshakeCompletedListener)handshakeCompletedListener);
        return tlsParams;
    }
}

