#include "vpbapi.h"
#include <stdio.h>

#define N 16000

int main(int argc, char *argv[]){
	WFILE	*inwavefile;
	WFILE	*outwavefile;
	char     buf[N];
	int      count=0;

	if (argc !=3){
		printf("Usage: %s <input wav file> <output mulaw wav file>\n",argv[0]);
		return(0);
	}
	vpb_wave_open_read(&inwavefile,argv[1]);
	if (inwavefile == NULL){
		printf("Failed to open [%s]\n",argv[1]);
		return(0);
	}
	vpb_wave_open_write(&outwavefile,argv[2],VPB_MULAW);
	if (outwavefile == NULL){
		printf("Failed to open [%s]\n",argv[2]);
		return(0);
	}
	do{
		count=vpb_wave_read(inwavefile,buf,sizeof(char));
		vpb_wave_write(outwavefile,buf,count);
//		printf(".");
	} while (count == N);
	vpb_wave_close_write(outwavefile);
	vpb_wave_close_write(inwavefile);
//	printf("\n");
	return(0);
}
