/*
 * Decompiled with CFR 0.152.
 */
package WIMSchem.ds;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Set;

public class TrivialDOM {
    public static final int TYPE_NODE = 1;
    public static final int TYPE_TEXT = 2;
    Node doc = null;

    public Node createNode(String Name) {
        return new Node(Name);
    }

    public Text createText(String Text2, boolean Preserve) {
        return new Text(Text2, Preserve);
    }

    public TrivialDOM() {
    }

    public TrivialDOM(String DocName) {
        this.doc = new Node(DocName);
    }

    public TrivialDOM(Node DocNode) {
        this.doc = DocNode;
    }

    public Node document() {
        return this.doc;
    }

    public String toString() {
        StringWriter out = new StringWriter();
        try {
            TrivialDOM.writeXML(out, this);
        }
        catch (IOException e) {
            return e.getMessage();
        }
        return out.toString();
    }

    public static TrivialDOM readXML(BufferedReader in) throws IOException {
        String str;
        ArrayList<String> chunks;
        block33: {
            String EOF = "ReadXML: unexpected end of file during parsing";
            chunks = new ArrayList<String>();
            str = "";
            while (true) {
                int ich;
                if (str.length() == 0) {
                    ich = in.read();
                    if (ich < 0) break block33;
                    str = String.valueOf((char)ich);
                }
                if (str.charAt(0) == '<') {
                    for (int n = 0; n < 2; ++n) {
                        ich = in.read();
                        if (ich < 0) {
                            throw new IOException("ReadXML: unexpected end of file during parsing");
                        }
                        str = str + (char)ich;
                    }
                    if (str.startsWith("<![")) {
                        do {
                            if ((ich = in.read()) >= 0) continue;
                            throw new IOException("ReadXML: unexpected end of file during parsing");
                        } while (!(str = str + (char)ich).endsWith("]]>"));
                        chunks.add(str);
                        str = "";
                        continue;
                    }
                    if (str.startsWith("<!-")) {
                        do {
                            if ((ich = in.read()) >= 0) continue;
                            throw new IOException("ReadXML: unexpected end of file during parsing");
                        } while (!(str = str + (char)ich).endsWith("-->"));
                        chunks.add(str);
                        str = "";
                        continue;
                    }
                    boolean inquot = false;
                    while (true) {
                        if ((ich = in.read()) < 0) {
                            throw new IOException("ReadXML: unexpected end of file during parsing");
                        }
                        str = str + (char)ich;
                        if ((char)ich == '\"') {
                            inquot = !inquot;
                            continue;
                        }
                        if ((char)ich == '>') break;
                    }
                    chunks.add(str);
                    str = "";
                    continue;
                }
                boolean eof = false;
                while (true) {
                    if ((ich = in.read()) < 0) {
                        eof = true;
                        break;
                    }
                    if ((char)ich == '<') {
                        chunks.add(str);
                        str = String.valueOf((char)ich);
                        break;
                    }
                    str = str + (char)ich;
                }
                if (eof) break;
            }
            if (str.trim().length() != 0) {
                throw new IOException("ReadXML: unexpected end of file during parsing");
            }
        }
        TrivialDOM xml = new TrivialDOM("unknown");
        Node node = null;
        for (int n = 0; n < chunks.size(); ++n) {
            str = (String)chunks.get(n);
            if (str.trim().length() == 0) continue;
            if (str.charAt(0) == '<' && str.length() >= 2 && (str.charAt(1) >= 'A' && str.charAt(1) <= 'Z' || str.charAt(1) >= 'a' && str.charAt(1) <= 'z') && str.endsWith(">")) {
                boolean isclosed = (str = str.substring(1, str.length() - 1)).endsWith("/");
                if (isclosed) {
                    str = str.substring(0, str.length() - 1);
                }
                String[] bits = str.split(" ");
                Node newNode = null;
                if (node == null) {
                    newNode = xml.document();
                    newNode.setNodeName(bits[0]);
                } else {
                    newNode = node.appendNode(bits[0]);
                }
                for (int i = 1; i < bits.length; ++i) {
                    int spc = bits[i].indexOf("=");
                    if (spc <= 0) {
                        throw new IOException("Malformatted attribute: [" + TrivialDOM.snip(bits[i]) + "].");
                    }
                    String key = bits[i].substring(0, spc);
                    String val = bits[i].substring(spc + 1);
                    if (!val.startsWith("\"") || !val.endsWith("\"")) {
                        throw new IOException("Malformed attribute value: [" + TrivialDOM.snip(bits[i]) + "].");
                    }
                    val = val.substring(1, val.length() - 1);
                    newNode.setAttribute(key, val);
                }
                if (isclosed) continue;
                node = newNode;
                continue;
            }
            if (str.startsWith("</")) {
                if (node == null) {
                    throw new IOException("Unexpected end tag: [" + TrivialDOM.snip(str) + "].");
                }
                if ((str = str.substring(2, str.length() - 1)).compareTo(node.nodeName()) != 0) {
                    throw new IOException("Closing tag does not match opening tag: [" + TrivialDOM.snip(str) + "].");
                }
                node = node.parent();
                continue;
            }
            if (str.startsWith("<![CDATA[")) {
                if (node == null) {
                    throw new IOException("Unexpected CDATA node: [" + TrivialDOM.snip(str) + "].");
                }
                if (!str.endsWith("]]>")) {
                    throw new IOException("CDATA node not ended: [" + TrivialDOM.snip(str) + "].");
                }
                str = str.substring(9, str.length() - 3);
                node.appendText(str, true);
                continue;
            }
            if (str.startsWith("<!--")) {
                if (str.endsWith("-->")) continue;
                throw new IOException("Unterminated comment: [" + TrivialDOM.snip(str) + "].");
            }
            if (str.startsWith("<?")) continue;
            if (str.startsWith("<")) {
                throw new IOException("Unexpected angle bracket, near: [" + TrivialDOM.snip(str) + "].");
            }
            if (node == null) {
                throw new IOException("Misplaced text-like block: [" + TrivialDOM.snip(str) + "].");
            }
            node.appendText(TrivialDOM.unescapeText(str).trim(), false);
        }
        return xml;
    }

    private static String snip(String str) {
        if (str.length() < 60) {
            return str;
        }
        return str.substring(0, 60) + "...";
    }

    public static void writeXML(Writer out, TrivialDOM dom) throws IOException {
        out.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        TrivialDOM.recursiveWriteNode(out, dom.document(), 0);
        out.flush();
    }

    private static void recursiveWriteNode(Writer out, Node nod, int Level2) throws IOException {
        int n;
        for (int n2 = 0; n2 < Level2; ++n2) {
            out.write(" ");
        }
        out.write("<" + nod.nodeName());
        String[] attr = nod.getAttributeNames();
        for (int n3 = 0; n3 < attr.length; ++n3) {
            out.write(" " + attr[n3] + "=\"" + TrivialDOM.escapeAttr(nod.attribute(attr[n3])) + "\"");
        }
        if (nod.numChildren() == 0) {
            out.write("/>\n");
            return;
        }
        out.write(">");
        boolean doIndent = true;
        if (nod.numChildren() == 1 && nod.childType(0) == 2) {
            doIndent = false;
        } else if (nod.numChildren() > 0 && nod.childType(0) == 2 && nod.getChildText(0).preserve()) {
            doIndent = false;
        }
        if (doIndent) {
            out.write("\n");
        }
        for (n = 0; n < nod.numChildren(); ++n) {
            if (nod.childType(n) == 2) {
                Text txt = nod.getChildText(n);
                if (doIndent) {
                    for (int i = 0; i < Level2 + 1; ++i) {
                        out.write(" ");
                    }
                }
                if (txt.preserve()) {
                    out.write("<![CDATA[" + txt.get() + "]]>");
                } else {
                    out.write(TrivialDOM.escapeText(txt.get()));
                }
                if (!doIndent) continue;
                out.write("\n");
                continue;
            }
            TrivialDOM.recursiveWriteNode(out, nod.getChildNode(n), Level2 + 1);
        }
        if (doIndent) {
            for (n = 0; n < Level2; ++n) {
                out.write(" ");
            }
        }
        out.write("</" + nod.nodeName() + ">\n");
    }

    public static String escapeAttr(String S) {
        int i;
        while ((i = S.indexOf(34)) >= 0) {
            S = S.substring(0, i) + "&quot;" + S.substring(i + 1);
        }
        while ((i = S.indexOf(39)) >= 0) {
            S = S.substring(0, i) + "&apos;" + S.substring(i + 1);
        }
        return S;
    }

    public static String escapeText(String S) {
        int i;
        String str = "";
        while ((i = S.indexOf(38)) >= 0) {
            str = str + S.substring(0, i) + "&amp;";
            S = S.substring(i + 1);
        }
        S = str + S;
        while ((i = S.indexOf(60)) >= 0) {
            S = S.substring(0, i) + "&lt;" + S.substring(i + 1);
        }
        while ((i = S.indexOf(62)) >= 0) {
            S = S.substring(0, i) + "&gt;" + S.substring(i + 1);
        }
        return S;
    }

    public static String unescapeText(String S) {
        String str = "";
        int i = 0;
        while (i < S.length()) {
            if (i + 5 <= S.length() && S.substring(i, i + 5).equals("&amp;")) {
                str = str + "&";
                i += 5;
                continue;
            }
            if (i + 4 <= S.length() && S.substring(i, i + 4).equals("&lt;")) {
                str = str + "<";
                i += 4;
                continue;
            }
            if (i + 4 <= S.length() && S.substring(i, i + 4).equals("&gt;")) {
                str = str + ">";
                i += 4;
                continue;
            }
            str = str + S.charAt(i);
            ++i;
        }
        return str;
    }

    class Text {
        private Node parentNode = null;
        private String text;
        private boolean preserve;

        public Text(String Text2, boolean Preserve) {
            this.text = Text2;
            this.preserve = Preserve;
        }

        public Node parent() {
            return this.parentNode;
        }

        public void setParent(Node Parent) {
            this.parentNode = Parent;
        }

        public String get() {
            return this.text;
        }

        public void set(String Txt) {
            this.text = Txt;
        }

        public boolean preserve() {
            return this.preserve;
        }
    }

    class Node {
        private Node parentNode = null;
        private String nodeName;
        private Hashtable<String, String> nodeAttr;
        private ArrayList<Object> children;

        public Node(String NodeName) {
            this.nodeName = NodeName;
            this.nodeAttr = new Hashtable();
            this.children = new ArrayList();
        }

        public Node parent() {
            return this.parentNode;
        }

        public void setParent(Node Parent) {
            this.parentNode = Parent;
        }

        public String nodeName() {
            return this.nodeName;
        }

        public void setNodeName(String Name) {
            this.nodeName = Name;
        }

        public String attribute(String Attr) {
            return this.nodeAttr.containsKey(Attr) ? this.nodeAttr.get(Attr) : null;
        }

        public void setAttribute(String Attr, String Value) {
            this.nodeAttr.put(Attr, Value);
        }

        public String[] getAttributeNames() {
            Set<String> attr = this.nodeAttr.keySet();
            String[] names = new String[attr.size()];
            return attr.toArray(names);
        }

        public int numChildren() {
            return this.children.size();
        }

        public int childType(int N) {
            Object child = this.children.get(N);
            if (child instanceof Node) {
                return 1;
            }
            if (child instanceof Text) {
                return 2;
            }
            return 0;
        }

        public Node getChildNode(int N) {
            return (Node)this.children.get(N);
        }

        public Text getChildText(int N) {
            return (Text)this.children.get(N);
        }

        public void clear() {
            this.children.clear();
        }

        public void deleteChild(int N) {
            this.children.remove(N);
        }

        public void setText(String Txt, boolean Preserve) {
            this.clear();
            Text txt = new Text(Txt, Preserve);
            txt.setParent(this);
            this.children.add(txt);
        }

        public String getText() {
            String txt = "";
            for (int n = 0; n < this.numChildren(); ++n) {
                txt = this.childType(n) == 2 ? txt + this.getChildText(n).get() : txt + this.getChildNode(n).getText();
            }
            return txt;
        }

        public void appendChild(Node Nod) {
            Nod.setParent(this);
            this.children.add(Nod);
        }

        public void appendChild(Text Txt) {
            Txt.setParent(this);
            this.children.add(Txt);
        }

        public void insertChild(int N, Node Nod) {
            Nod.setParent(this);
            this.children.add(N, Nod);
        }

        public void insertChild(int N, Text Txt) {
            Txt.setParent(this);
            this.children.add(N, Txt);
        }

        public Node appendNode(String Name) {
            Node nod = new Node(Name);
            nod.setParent(this);
            this.children.add(nod);
            return nod;
        }

        public Text appendText(String Txt, boolean Preserve) {
            Text txt = new Text(Txt, Preserve);
            txt.setParent(this);
            this.children.add(txt);
            return txt;
        }
    }
}

