/*
 * This code implements the MD5 message-digest algorithm.
 * The algorithm is due to Ron Rivest.  This code was
 * written by Colin Plumb in 1993, no copyright is claimed.
 * This code is in the public domain; do with it what you wish.
 *
 * Equivalent code is available from RSA Data Security, Inc.
 * This code has been tested against that, and is equivalent,
 * except that you don't need to include two pages of legalese
 * with every copy.
 *
 * To compute the message digest of a chunk of bytes, declare an
 * MD5Context structure, pass it to MD5Init, call MD5Update as
 * needed on buffers full of bytes, and then call MD5Final, which
 * will fill a supplied 16-byte array with the digest.
 */

#ifndef OMEGA_INCLUDED_MD5_H
#define OMEGA_INCLUDED_MD5_H

/* Minor tweaks for use from Omega:
 *
 * + Include <cstdint> to get uint32_t.
 * + uint32 -> uint32_t.
 * + MD5Transform is an internal helper so prototype moved to md5.cc.
 * + Removed MD5_CTX.
 * + Changed MD5Context.in to uint32_t instead of unsigned char.
 * + Added "OMEGA_INCLUDED_" prefix to header guard macro.
 */

// To get uint32_t:
#include <cstdint>
using std::uint32_t;

struct MD5Context {
    uint32_t buf[4];
    uint32_t bits[2];
    uint32_t in[16];
};

void MD5Init(struct MD5Context *context);
void MD5Update(struct MD5Context *context, unsigned char const *buf,
	       unsigned len);
void MD5Final(unsigned char digest[16], struct MD5Context *context);

#endif /* OMEGA_INCLUDED_MD5_H */
