# recreate main.fig using pyscript

from math import *
from pyscript.lib.presentation import TeXBox
from pyscript.lib.misc import Arrow

def text_box(text,textScale=1.9):
    buffer = 0.2
    tex = TeX(text).scale(textScale)
    rect = Rectangle(c=tex.c,
                     width = tex.bbox().width+buffer,
                     height = tex.bbox().height+buffer,
                     fg=Color(0),
                     linewidth=1.0)
    return Group(rect,tex)

textScale = 1.9

beginCirc = Circle(fg=Color(0),r=1.0)
beginText = TeX(r"\sf Begin").scale(textScale)
beginText.c = beginCirc.c
begin = Group(beginCirc,beginText)

box1 = text_box(r"\sf Process command line arguments")
box2 = text_box(r"\sf Parse input file")
box3 = text_box(r"\sf Process simulation element")
box4 = text_box(r"\sf Generate output code")
box5 = text_box(r"\sf Call system compiler")

endCirc = Circle(fg=Color(0),r=1.0)
endText = TeX(r"\sf End").scale(textScale)
endText.c = endCirc.c
end = Group(endCirc,endText)

arrow = Arrow(start=P(0,0),end=P(0,-1.0),fg=Color(0),dh=0.1)

overview = Align(begin, arrow, 
		box1, arrow.copy(), 
		box2, arrow.copy(), 
		box3, arrow.copy(), 
		box4, arrow.copy(), 
		box5, arrow.copy(), 
		end,
		a1="s",a2="n",space=-0.1)

dbox1 = text_box(r"\sf Write includes")
dbox2 = text_box(r"\sf Write defines")
dbox3 = text_box(r"\sf Write globals")
dbox4 = text_box(r"\sf Write prototypes")
dbox5 = text_box(r"\sf Write routines")

details = Align(dbox1, arrow.copy(),
		dbox2, arrow.copy(),
		dbox3, arrow.copy(),
		dbox4, arrow.copy(),
		dbox5,
		a1="s",a2="n",space=-0.1)
details.sw = overview.se + P(2.0,1.0)

path1 = Path(overview.e-P(1.2,2),details.nw,dash='[ 2] 0')
path2 = Path(overview.e-P(1.2,2),details.sw,dash='[ 2] 0')

render(
    overview,
    details,
    path1,path2,
    file="main.eps",
)

