.TH XWatch 1
.SH XWatch 
xwatch \- The Logfiles Watcher 
.SH Karel Kubat (karel@icce\&.rug\&.nl)
State University of Groningen 
.br 
Westerhaven 16, 9718 AW Groningen 
.br 
The Netherlands
.bp 
.SH Contents 
Chapter 1: Introduction 
.br
Chapter 2: Using xwatch 
.br
2\&.1: Options to the xwatch program 
.br
2\&.2: File arguments 
.br
Chapter 3: Obtaining xwatch 
.br
Chapter 4: Compiling xwatch 
.br
Chapter 5: Copyright 
.br
.bp 
.PP 
.SH "Chapter 1: Introduction" 
.PP 
\f(CWXWatch\fP is a small program that I wrote to monitor logfiles and to see
any changes \fBdirectly\fP (instead of having to read all the logs after a
breakin or a crash)\&. \f(CWXWatch\fP is simply started with a few file
arguments, and any information that appears on the files is displayed\&.
With a slider you can see past information; i\&.e\&., lines that scroll in
\f(CWxwatch\fP\'s window\&. That\'s all there is to it\&. The appearance of the
\f(CWxwatch\fP window can furthermore be modified via command line flags or
via an application defaults file\&. (Older versions of \f(CWXWatch\fP had a
button to activate an `options\' window\&. I removed this code, almost no-one
uses it\&.)
.PP 
\f(CWXWatch\fP is incidentally my first applications with the XForms GUI
library for X, which I can highly recommend for developers who want to
start `X programming\' but who don\'t want to go through the hassle of
having to learn about intrinsics\&. XForms is really excellent\&. Congrats,
T\&.C\&. Zhao and Mark Overmars (the latter is rumored to bootleg at a soccer
club in his free time ;)\&. Instructions on where and how to get the XForms
library are in the \f(CWMakefile\fP, contained in \f(CWxwatch\fP\'s distribution\&.
.PP 
.SH "Chapter 2: Using xwatch" 
.PP 
You typically start \f(CWxwatch\fP when activating an X session; e\&.g\&.,
from the file which xdm uses to fire up a user\'s session (this file is
normally \f(CW/usr/X11/lib/X11/xdm/Xsession\fP)\&. The command that starts
\f(CWxwatch\fP is something like
.PP 

.DS 
 
xwatch [options] files &

.DE 
 
 
.PP 
where `options\' are optional flags, files are the files to watch, and
the ampersand character is used to start \f(CWxwatch\fP in the background\&. The
files to watch are typically in the directory \f(CW/var/adm/\fP: files which
are created by the syslog daemon (see the file \f(CWsyslogd\&.conf\&.SAMPLE\fP in
the distribution for an example)\&.  \f(CWXWatch\fP accepts only filenames which
are:
.PP 
.IP 
.IP o 
ordinary files, no sockets, directory names,
.IP 
.IP o 
which are not binary files\&.
.IP 
.PP 
Other files as stated on the commandline are not monitored\&. When any
`non-proper\' file is given on the commandline, \f(CWxwatch\fP warns about the
file not being acceptable and deletes it from its list of names\&.
.PP 
.SH "2\&.1: Options to the xwatch program" 
.PP 
The options are many, start \f(CWxwatch\fP without arguments to see what is
supported\&. All options can also be stated in the file
\f(CW/usr/lib/X11/app-defaults/XWatch\fP as X resources (see the file
\f(CWXWatch\&.ap\fP as an example)\&. In the following enumeration, a \fInr\fP
denotes a number:
.PP 
.IP 
.IP o 
\f(CW-border\fP \fInr\fP:  Specifies whether \f(CWxwatch\fP should start
with a border\&. The \fInr\fP must be 0 or 1\&. When you start \f(CWxwatch\fP
without a border, your window manager may not be able to resize or
even recognize it\&. Incidentally, this may be what you want -- I use it
to `hide\' the presence of \f(CWxwatch\fP from my window manager \f(CWfvwm\fP\&. 
.IP 
.IP o 
\f(CW-geometry\fP \fIgeom\fP: Specifies the display geometry, a-la 
other X programs\&. You can express the geometry in terms of \fIWxH\fP 
(width by height), optionally postfixed by \fI+X+Y\fP (x and y offset) 
or \fI-X-Y\fP (offsets relative to the lower right corner) and other 
combinations\&. 
.IP 
Note that previous switches that emulated the geometry specification, 
such as \f(CW-xpos\fP and \f(CW-height\fP, are now obsolete\&. Use the geometry 
setting\&.
.IP 
.IP o 
\f(CW-fg\fP \fIcolor\fP and \f(CW-bg\fP \fIcolor\fP: These options define the 
default foreground and background of the watch window\&.
.IP 
Note that previous switches, such as \f(CW-bred\fP and \f(CW-bblue\fP, are now 
obsolete\&. 
.IP 
.IP o 
\f(CW-printtime\fP \fInr\fP: Defines whether \f(CWxwatch\fP should prefix
any info on the watched files with a timestamp\&. The \f(CWnr\fP can be 0 or
zero; the timestamp is printed when \fInr\fP is 1\&.
.IP 
.IP o 
\f(CW-printname\fP \fInr\fP: Defines whether \f(CWxwatch\fP should prefix
any info on the watched files with the filename\&. The \fInr\fP is again a
flag, 0 or 1\&.
.IP 
.IP o 
\f(CW-newline\fP \fInr\fP: Defines whether \f(CWxwatch\fP should let a
newline follow the time and/or filename stamp, so that the actual
information is displayed on its own line\&.
.IP 
.IP o 
\f(CW-interval\fP \fInr\fP: Defines the scanning interval\&.  Each \fInr\fP
seconds, \f(CWxwatch\fP will check if new information has arrived on the
watched files\&. The \fInr\fP may be between 1 and 30 seconds\&. 
.IP 
.IP o 
\f(CW-fontsize\fP \fInr\fP: Defines the initial size of the display
font\&.  The \fInr\fP may range from 1 to 4; 1 being the smallest font and
4 being the largest\&.
.IP 
.IP o 
\f(CW-fontstyle\fP \fInr\fP: Defines the style of the used font\&. The
\fInr\fP is a number between 0 and 15 (0 being the default)\&. Start
\f(CWxwatch\fP without arguments or read the application defaults file to
see what fonts the numbers choose\&.
.IP 
.IP o 
\f(CW-firstwarnings\fP \fInr\fP: Defines whether \f(CWxwatch\fP should
print initial warnings into the watch window\&.  E\&.g\&., you might like to
set \f(CWfirstwarnings\fP to zero, and then start \f(CWxwatch\fP with the file
argument \f(CW/var/adm/*\fP\&.  Warnings about, e\&.g\&., \f(CWutmp\fP being a
binary file would then be suppressed\&.
.IP 
.IP o 
\f(CW-printversion\fP \fInr\fP: Controls whether \f(CWxwatch\fP prints its
version number and copyright notice upon startup in the watch window\&.
.IP 
.IP o 
\f(CW-gag\fP \fItext\fP: This option, when present, prevents all lines 
with \fItext\fP in them from being shown in the display window\&. You can 
specify more than one string to `gag\', in that case, separate the 
strings with \f(CW|\fP\&.
.IP 
.IP o 
\f(CW-colorstring\fP \fIcol:string\fP: This option causes lines that 
contain \f(CWstring\fP to be displayed using the specified color\&.
The string is matched literally\&. 
E\&.g\&., if you use the option \f(CW-colorstring blue:connection\fP then 
all lines containing \f(CWconnection\fP are displayed in pure blue\&.
.IP 
You can specify several colorstrings by separating all options with a 
| character, as in \f(CW-colorstring blue:connection|red:error\fP\&. Note 
that, for reasons of shell expansion, you should quote such options on 
the commandline\&.
.IP 
.IP o 
\f(CW-title\fP \fIname\fP: This option sets the window title of the 
watch window\&. Note that the title will only be visible when \f(CWborder\fP 
is not 0\&. This option may be useful if you have several XWatch 
windows, monitoring different things\&.
.IP 
.IP o 
\f(CW-ignore\fP \fIfileA|fileB|fileC|\&.\&.\&.\fP: This option is handy if 
you start XWatch with a wildcard file argument, but when you want 
XWatch \fBnot\fP to process some files\&. The \f(CW-ignore\fP flag removes 
the stated files from the watchlist\&. Note that, for reasons of shell 
commandline expansion, you must quote the file specification (or the 
shell will interpret the | characters as pipes)\&. (Thanks, Frank 
Brokken, \f(CWfrank@icce\&.rug\&.nl\fP for the code)\&.
.IP 
.PP 
Before you extensively use the options, create an application defaults
file \f(CW/usr/lib/X11/app-defaults/XWatch\fP\&. You can do so by copying the
file \f(CWXWatch\&.ap\fP, extracted from the archive, to
\f(CW/usr/lib/X11/app-defaults/XWatch\fP\&. The comments in the distributed 
application defaults file explain what you can configure and show 
examples\&. 
.PP 
Some systems do not have the directory \f(CW/usr/lib/X11/app-defaults\fP\&.  In
that case, you should create the following links:
.PP 
.IP 
.IP o 
\f(CW/usr/X11\fP should point to your X11 distribution; e\&.g\&.  to
\f(CW/usr/X11R6\fP\&. That way, you always have e\&.g\&.  \f(CW/usr/X11/bin\fP, even
after upgrading your X11 distribution\&. All that is needed is one new
link\&.
.IP 
.IP o 
\f(CW/usr/lib/X11\fP should point to \f(CW/usr/X11/lib/X11\fP\&.
.IP 
.PP 
Then edit the file \f(CWXWatch\fP in the application defaults directory, and
follow the instructions therein to define your favorite settings\&.  If you
need to start \f(CWxwatch\fP incidentally with another setting, use a flag\&.
.PP 
.SH "2\&.2: File arguments" 
.PP 
The filename arguments can optionally be followed by a color
specification that applies only to that particular file\&. E\&.g\&., say you
want to see all the files in \f(CW/var/adm\fP normally in blue text; but you
want to see \f(CW/var/adm/critical\fP (critical messages from applications) in
yellow and \f(CW/var/adm/auth\fP (authentification messages) in red\&. In that
case, the course to follow would be:
.PP 
.IP 
.IP o 
The default foreground color would be blue\&. You could set this
with the flags \f(CW-fg blue\fP, or in the application
defaults file\&.
.IP 
.IP o 
The color for \f(CW/var/adm/critical\fP should be yellow\&.  Hence, the
first file argument would be \f(CW/var/adm/critical:yellow\fP\&.
.IP 
.IP o 
The color for file \f(CW/var/adm/auth\fP should be red, hence the
second file argument would be \f(CW/var/adm/auth:red\fP\&.
.IP 
.IP o 
The following arguments would be the files, using the standard
foreground (blue): \f(CW/var/adm/*\fP, without any extra color
specifications\&.
.IP 
.PP 
Such a commandline would cause \f(CWxwatch\fP to complain about the multiple
presence of \f(CW/var/adm/critical\fP (once from the separate argument, and
once from the wildcard argument) and similarly about \f(CW/var/adm/auth\fP\&. If
this bothers you, turn off the initial warnings (e\&.g\&., using
\f(CW-firstwarnings 0\fP or in the application defaults file)\&.
.PP 
Note that besides the color specifications for filenames, you can 
also specify coloring for lines that match a given string in all files\&. 
See the above description of the  switch \f(CW-colorstring\fP for more 
information\&.
.PP 
.PP 
.PP 
.SH "Chapter 3: Obtaining xwatch" 
.PP 
\f(CWXWatch\fP can be obtained at the ftp site \f(CWftp\&.icce\&.rug\&.nl\fP, in the directory \f(CW/pub/unix\fP, as the file \f(CWxwatch-X\&.YY\&.tar\&.gz\fP\&.
\f(CWX\&.YY\fP is the version number, e\&.g\&., 1\&.00\&. This site is the primary site,
so check here for new versions\&.
.PP 
To unpack the archive, change-dir to your `sources\' directory (e\&.g\&.,
\f(CW/usr/local/src\fP) and type
.PP 

.DS 
 
tar xvzf /where/ever/you/put/it/xwatch-X\&.YY\&.tar\&.gz

.DE 
 
 
.PP 
Next, change-dir to the unpacked subdirectory \f(CWxwatch\fP and check there\&.
You will find a subdirectory \f(CWsrc\fP with the full sources\&.
.PP 
.SH "Chapter 4: Compiling xwatch" 
.PP 
.PP 
Follow these steps\&.
.PP 
.IP 
.IP o 
You will need the XForms library and include files to compile
\f(CWxwatch\fP\&.  Check the \f(CWMakefile\fP in the \f(CWsrc\fP subdirectory for
two ftp sites that carry XForms for Linux\&. Obtain the library and
install it\&.  XWatch will happily run with XForms version 0\&.81 or 0\&.88\&.
.IP 
.IP o 
In the \f(CWsrc\fP subdirectory, edit the \f(CWMakefile\fP and adjust
some defines at the top\&. E\&.g\&., a \f(CWmake install\fP copies the binary by
default to \f(CW/usr/local/X11/bin\fP; adjust that if you don\'t like this
behavior\&.
.IP 
.IP o 
Next, do a \f(CWmake install\fP, followed by a \f(CWmake clean\fP\&.
.IP 
.IP o 
Copy the file \f(CWXWatch\&.ap\fP from the source directory to 
\f(CW/usr/lib/X11/app-defaults/XWatch\fP\&. Edit the file and state your 
favorite settings\&.
.IP 
.IP o 
Next, start the program \f(CWxwatch\fP with some file arguments in 
your logfiles directory\&. If you\'re satisfied with the appearance and 
workings of \f(CWxwatch\fP, add the invocation to your script that starts
an X session\&.
.IP 
.PP 
.SH "Chapter 5: Copyright" 
.PP 
XWatch - a tool to monitor logfiles and display new logs in an X window\&.  
Copyright (C) 1995 Karel Kubat\&.  All rights reserved\&.
.PP 
This program is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version\&.
.PP 
You may link this software with XForms (Copyright (C) by T\&.C\&. Zhao and
Mark Overmars) and distribute the resulting binary, under the
restrictions in clause 3 of the GPL, even though the resulting binary is
not, as a whole, covered by the GPL\&. (You still need a separate license
to do so from the owner(s) of the copyright for XForms, however)\&.  If a
derivative no longer requires XForms, you may use the unsupplemented GPL
as its license by deleting this paragraph and therefore removing this
exemption for XForms\&.
.PP 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE\&.  See the
GNU General Public License for more details\&.
.PP 
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc\&., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
