#import <Foundation/Foundation.h>
#import "TarTestCase.h"
#import "TarArchive.h"
#import "FileInfo.h"
#import "Preferences.h"
#import "MockTarArchive.h"

@implementation TarTestCase : ArchiveTestCase

- (void)dealloc
{
	[_preferences release];
	[super dealloc];
}

- (void)setUp;
{
	_preferences = [[NSMutableDictionary dictionaryWithObjectsAndKeys:
		@"/bin/tar", PREF_KEY_TAR, nil] retain];
	[Preferences usePreferences:_preferences];
}

- (Archive *)sampleArchive
{	
    NSString * path = [NSBundle pathForResource:@"sample.tar"  
		ofType:@"gz" inDirectory:@"TestResources"];
    [self assertNotNil:path];
    path = [path stringByStandardizingPath];
    return [TarArchive newWithPath:path];
}

- (void)testLinuxTarOutput
{	
	FileInfo *info;
	
	// make sure the prefs are correct
	[_preferences setObject:@"NO" forKey:PREF_KEY_BSD_TAR];

	NSString *path = [NSBundle pathForResource:@"tar-linux" ofType:@"out"
		inDirectory:@"TestResources"];
	[self assertNotNil:path];
	
	MockTarArchive *mockTar = [[[MockTarArchive alloc] initFromFile:path] autorelease];
	NSArray *elements = [mockTar elements];
	
	[self assertInt:[elements count] equals:7];
	[mockTar sortByFilename];
	info = [mockTar elementAtIndex:0];
	[self assert:[info filename] equals:@".procmailrc"];
	[self assert:[[info date] description] equals:@"2003-04-24 07:08:43"];
}

- (void)testBsdTarOutput
{
	FileInfo *info;

	// make sure the prefs are correct
	[_preferences setObject:@"YES" forKey:PREF_KEY_BSD_TAR];

	NSString *path = [NSBundle pathForResource:@"tar-bsd" ofType:@"out"
		inDirectory:@"TestResources"];
	[self assertNotNil:path];
	
	MockTarArchive *mockTar = [[[MockTarArchive alloc] initFromFile:path] autorelease];
	NSArray *elements = [mockTar elements];

	[self assertInt:[elements count] equals:7];
	[mockTar sortByFilename];
	info = [mockTar elementAtIndex:0];
	[self assert:[info filename] equals:@".procmailrc"];
	[self assert:[[info date] description] equals:@"Apr 24 07:08 2003"];
}

@end
